/*
 * Decompiled with CFR 0.152.
 */
package top.jfunc.common.report;

import com.jfinal.plugin.activerecord.Record;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.jfunc.common.report.AbstractExportUploadService;

public abstract class AbstractExportUploadTxtService
extends AbstractExportUploadService<Record> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractExportUploadTxtService.class);

    protected abstract String convertRecordToString(Record var1);

    protected abstract String linePrefix(Record var1);

    protected String firstLine() {
        return null;
    }

    protected String lastLine() {
        return null;
    }

    protected String charset() {
        return "GBK";
    }

    @Override
    protected void export(String fileName, String filePath) {
        try {
            this.exportData(filePath, this.firstLine(), this.lastLine());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void exportData(String filePath, String firstLine, String lastLine) throws Exception {
        int i = 1;
        try (OutputStreamWriter osr = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(filePath)), this.charset());){
            List<Record> list;
            if (null != firstLine) {
                osr.write(firstLine);
                osr.write("\r\n");
            }
            while (null != (list = this.getList(i++, PAGE_SIZE)) && list.size() != 0) {
                this.outputToFile(list, osr);
                if (list.size() < PAGE_SIZE) {
                    list.clear();
                    break;
                }
                list.clear();
            }
            if (null != lastLine) {
                osr.write(lastLine);
                osr.write("\r\n");
            }
        }
    }

    private void outputToFile(List<Record> list, OutputStreamWriter osr) {
        for (int i = 0; i < list.size(); ++i) {
            try {
                Record item = list.get(i);
                osr.write(this.linePrefix(item) + this.convertRecordToString(item));
                osr.write("\r\n");
                continue;
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

