/*
 * Decompiled with CFR 0.152.
 */
package top.jfunc.common.excel;

import com.jfinal.plugin.activerecord.Record;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.jfunc.common.ProgressNotifier;
import top.jfunc.common.db.DBHelper;
import top.jfunc.common.excel.ExportUtils;

public class ExcelLargeDataUtils {
    private static Logger logger = LoggerFactory.getLogger(ExcelLargeDataUtils.class);

    public static void exportData(DBHelper helper, String[] headers, String[] columns, String sql, String exportFilePath) throws Exception {
        ExcelLargeDataUtils.exportData(helper, headers, columns, sql, exportFilePath, null);
    }

    public static void exportData(Connection connection, String[] headers, String[] columns, String sql, String exportFilePath) throws Exception {
        ExcelLargeDataUtils.exportData(connection, headers, columns, sql, exportFilePath, null);
    }

    public static void exportData(DBHelper helper, String[] headers, String[] columns, String sql, String exportFilePath, ProgressNotifier progress) throws Exception {
        long startAll = System.currentTimeMillis();
        File file = new File(exportFilePath);
        if (!file.exists()) {
            file.createNewFile();
        }
        FileOutputStream fos = null;
        PreparedStatement pst = null;
        try {
            fos = new FileOutputStream(exportFilePath);
            pst = helper.getPrepareStatement(sql);
            ResultSet resultSet = pst.executeQuery();
            int count = ExcelLargeDataUtils.export2Excel(headers, columns, fos, resultSet, progress);
            resultSet.close();
            logger.info(String.format("count=%d,use time=%d", count, System.currentTimeMillis() - startAll));
        }
        catch (IOException | SQLException e) {
            try {
                logger.error(e.getMessage(), (Throwable)e);
                if (null != progress) {
                    progress.error(e);
                }
                throw new Exception(e);
            }
            catch (Throwable throwable) {
                ExcelLargeDataUtils.close(fos, pst, helper);
                throw throwable;
            }
        }
        ExcelLargeDataUtils.close(fos, pst, helper);
    }

    public static void exportData(Connection connection, String[] headers, String[] columns, String sql, String exportFilePath, ProgressNotifier progress) throws Exception {
        boolean newFile;
        long startAll = System.currentTimeMillis();
        File file = new File(exportFilePath);
        if (!file.exists() && !(newFile = file.createNewFile())) {
            logger.error("\u751f\u6210\u6587\u4ef6\u5931\u8d25 : " + file.getAbsolutePath());
        }
        FileOutputStream fos = null;
        PreparedStatement pst = null;
        try {
            fos = new FileOutputStream(exportFilePath);
            pst = connection.prepareStatement(sql, 1003, 1007);
            pst.setFetchSize(Integer.MIN_VALUE);
            pst.setFetchDirection(1001);
            ResultSet resultSet = pst.executeQuery();
            int count = ExcelLargeDataUtils.export2Excel(headers, columns, fos, resultSet, progress);
            resultSet.close();
            logger.info(String.format("count=%d,use time=%d", count, System.currentTimeMillis() - startAll));
        }
        catch (Exception e) {
            try {
                logger.error(e.getMessage(), (Throwable)e);
                if (null != progress) {
                    progress.error(e);
                }
                throw new Exception(e);
            }
            catch (Throwable throwable) {
                ExcelLargeDataUtils.close(fos, pst, null);
                throw throwable;
            }
        }
        ExcelLargeDataUtils.close(fos, pst, null);
    }

    private static int export2Excel(String[] headers, String[] columns, FileOutputStream fos, ResultSet resultSet, ProgressNotifier progress) throws SQLException, IOException {
        int count = 0;
        ArrayList<Record> list = new ArrayList<Record>();
        int rowIndex = 1;
        ExportUtils exportUtils = new ExportUtils(headers);
        if (null != progress) {
            progress.start();
        }
        while (resultSet.next()) {
            Record record = new Record();
            for (int i = 0; i < columns.length; ++i) {
                record.set(columns[i], resultSet.getObject(columns[i]));
            }
            list.add(record);
            if (++count % 5000 != 0) continue;
            if (null != progress) {
                progress.progressed((long)count);
            }
            exportUtils.exportExcel(columns, list, "", rowIndex);
            rowIndex += list.size();
            list.clear();
        }
        if (list.size() > 0) {
            if (null != progress) {
                progress.progressed((long)count);
            }
            exportUtils.exportExcel(columns, list, "", rowIndex);
            list.clear();
        }
        exportUtils.write(fos);
        if (null != progress) {
            progress.finish((long)count);
        }
        return count;
    }

    private static void close(FileOutputStream fos, PreparedStatement pst, DBHelper dbHelper) {
        if (fos != null) {
            try {
                fos.close();
            }
            catch (IOException e) {
                logger.error("fos\u5173\u95ed\u5f02\u5e38", (Throwable)e);
            }
        }
        if (pst != null) {
            try {
                pst.close();
            }
            catch (SQLException e) {
                logger.error("pst\u5173\u95ed\u5f02\u5e38", (Throwable)e);
            }
        }
        if (dbHelper != null) {
            dbHelper.close();
        }
    }
}

