/*
 * Decompiled with CFR 0.152.
 */
package top.jfunc.common.excel.asyncexport;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.jfunc.common.event.core.ApplicationListener;
import top.jfunc.common.event.core.ListenerAttr;
import top.jfunc.common.excel.ExcelLargeDataUtils;
import top.jfunc.common.excel.asyncexport.ExportExcelBean;
import top.jfunc.common.excel.asyncexport.ExportExcelEvent;

public class ExportExcelListener
implements ApplicationListener<ExportExcelEvent>,
ListenerAttr {
    private static final Logger logger = LoggerFactory.getLogger(ExportExcelListener.class);

    public void onApplicationEvent(ExportExcelEvent event) {
        ExportExcelBean bean = (ExportExcelBean)event.getSource();
        String[] headers = bean.getHeaders();
        String[] columns = bean.getColumns();
        String sql = bean.getSql();
        String exportFilePath = bean.getExportFilePath();
        Runnable callback = bean.getCallback();
        logger.info(exportFilePath);
        try {
            ExcelLargeDataUtils.exportData(bean.getHelper(), headers, columns, sql, exportFilePath);
            if (null != callback) {
                callback.run();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
    }

    public int getOrder() {
        return 1;
    }

    public boolean getEnableAsync() {
        return true;
    }

    public String getTag() {
        return "default_tag";
    }
}

