/*
 * Decompiled with CFR 0.152.
 */
package top.jfunc.common.fastexcel;

import com.jfinal.plugin.activerecord.Model;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import top.jfunc.common.db.bean.Record;
import top.jfunc.common.excel.AppendMoreData;
import top.jfunc.common.fastexcel.Workbook;
import top.jfunc.common.fastexcel.Worksheet;
import top.jfunc.common.utils.BeanUtil;

public class FastExcelExporter {
    public static final String VERSION_2003 = "2003";
    private static final int HEADER_ROW = 1;
    private static final int MAX_ROWS = 65535;
    private String version;
    private String[] sheetNames = new String[]{"sheet"};
    private int cellWidth = 8000;
    private int headerRow;
    private String[][] headers;
    private String[][] columns;
    private List<?>[] data;
    private AppendMoreData[] append;
    private String application;
    private OutputStream os;

    public FastExcelExporter(List<?> ... data) {
        this.data = data;
    }

    public static FastExcelExporter data(List<?> ... data) {
        return new FastExcelExporter(data);
    }

    public static List<List<?>> dice(List<?> num, int chunkSize) {
        int size = num.size();
        int chunk_num = size / chunkSize + (size % chunkSize == 0 ? 0 : 1);
        ArrayList result = new ArrayList();
        for (int i = 0; i < chunk_num; ++i) {
            result.add(new ArrayList(num.subList(i * chunkSize, i == chunk_num - 1 ? size : (i + 1) * chunkSize)));
        }
        return result;
    }

    public void export() throws IOException {
        int i;
        if ((this.data == null || this.data.length == 0) && this.append != null && this.append.length > 0) {
            List[] firstData = new List[this.append.length];
            for (i = 0; i < this.append.length; ++i) {
                firstData[i] = this.append[i].append();
            }
            this.set(firstData);
        }
        if (null == this.data) {
            throw new NullPointerException("data can not be null");
        }
        if (null == this.headers) {
            throw new NullPointerException("headers can not be null");
        }
        if (null == this.columns) {
            throw new NullPointerException("columns can not be null");
        }
        if (this.data.length != this.sheetNames.length || this.sheetNames.length != this.headers.length || this.headers.length != this.columns.length) {
            throw new IllegalArgumentException("data,sheetNames,headers and columns'length should be the same.(data:" + this.data.length + ",sheetNames:" + this.sheetNames.length + ",headers:" + this.headers.length + ",columns:" + this.columns.length + ")");
        }
        if (this.cellWidth < 0) {
            throw new IllegalArgumentException("cellWidth can not be less than 0");
        }
        Workbook wb = new Workbook(this.os, this.application, this.version);
        if (this.data.length == 0) {
            return;
        }
        for (i = 0; i < this.data.length; ++i) {
            Worksheet ws = wb.newWorksheet(this.sheetNames[i] == null ? "Sheet " + i : this.sheetNames[i]);
            this.handleHeader(ws, this.headers[i]);
            List<?> temp = this.data[i];
            int current = 0;
            do {
                this.handleData(i, ws, temp, current);
                current += temp.size();
            } while (this.append != null && (temp = this.append[i].append()) != null);
        }
        wb.finish();
    }

    private void handleHeader(Worksheet ws, String[] header) {
        if (header.length > 0) {
            if (this.headerRow <= 0) {
                this.headerRow = 1;
            }
            this.headerRow = Math.min(this.headerRow, 65535);
            int lenH = header.length;
            for (int h = 0; h < lenH; ++h) {
                ws.value(0, h, header[h]);
            }
        }
    }

    private void handleData(int sheetIndex, Worksheet ws, List<?> data, int dataIndex) {
        int len = data.size();
        for (int j = 0; j < len; ++j) {
            Object obj = data.get(j);
            if (obj == null) continue;
            if (obj instanceof Map) {
                FastExcelExporter.processAsMap(this.columns[sheetIndex], ws, j + this.headerRow + dataIndex, (Map)obj);
                continue;
            }
            if (obj instanceof Model) {
                FastExcelExporter.processAsModel(this.columns[sheetIndex], ws, j + this.headerRow + dataIndex, (Model)obj);
                continue;
            }
            if (obj instanceof com.jfinal.plugin.activerecord.Record) {
                FastExcelExporter.processAsRecord(this.columns[sheetIndex], ws, j + this.headerRow + dataIndex, (com.jfinal.plugin.activerecord.Record)obj);
                continue;
            }
            if (obj instanceof Record) {
                FastExcelExporter.processAsRecord(this.columns[sheetIndex], ws, j + this.headerRow + dataIndex, (Record)obj);
                continue;
            }
            if (obj instanceof Object[]) {
                FastExcelExporter.processAsArray(this.columns[sheetIndex], ws, j + this.headerRow + dataIndex, (Object[])obj);
                continue;
            }
            FastExcelExporter.processAsBean(this.columns[sheetIndex], ws, j + this.headerRow + dataIndex, obj);
        }
    }

    private static void processAsBean(String[] columns, Worksheet ws, int index, Object obj) {
        if (columns.length == 0) {
            throw new RuntimeException("\u8bf7\u6307\u5b9a\u5217\uff1acolumns");
        }
        int len = columns.length;
        for (int j = 0; j < len; ++j) {
            Object value = BeanUtil.get((Object)obj, (String)columns[j]);
            ws.value(index, j, value == null ? "" : value);
        }
    }

    private static void processAsArray(String[] columns, Worksheet ws, int index, Object[] map) {
        if (columns.length == 0) {
            throw new RuntimeException("\u8bf7\u6307\u5b9a\u5217\uff1acolumns");
        }
        int len = columns.length;
        for (int j = 0; j < len; ++j) {
            ws.value(index, j, map[j] == null ? "" : map[j]);
        }
    }

    private static void processAsMap(String[] columns, Worksheet ws, int index, Map<String, Object> map) {
        if (columns.length == 0) {
            Set<Map.Entry<String, Object>> entries = map.entrySet();
            int columnIndex = 0;
            for (Map.Entry<String, Object> entry : entries) {
                ws.value(index, columnIndex, entry.getValue());
                ++columnIndex;
            }
        } else {
            int len = columns.length;
            for (int j = 0; j < len; ++j) {
                ws.value(index, j, map.get(columns[j]) == null ? "" : map.get(columns[j]));
            }
        }
    }

    private static void processAsModel(String[] columns, Worksheet ws, int index, Model<?> model) {
        com.jfinal.plugin.activerecord.Record record = model.toRecord();
        FastExcelExporter.processAsRecord(columns, ws, index, record);
    }

    private static void processAsRecord(String[] columns, Worksheet ws, int index, com.jfinal.plugin.activerecord.Record record) {
        Map map = record.getColumns();
        FastExcelExporter.processAsMap(columns, ws, index, map);
    }

    private static void processAsRecord(String[] columns, Worksheet ws, int index, Record record) {
        Map map = record.getColumns();
        FastExcelExporter.processAsMap(columns, ws, index, map);
    }

    public FastExcelExporter application(String name) {
        this.application = name;
        return this;
    }

    public FastExcelExporter os(OutputStream os) {
        this.os = os;
        return this;
    }

    public FastExcelExporter version(String version) {
        this.version = version;
        return this;
    }

    public FastExcelExporter sheetName(String sheetName) {
        this.sheetNames = new String[]{sheetName};
        return this;
    }

    public FastExcelExporter sheetNames(String ... sheetName) {
        this.sheetNames = sheetName;
        return this;
    }

    public FastExcelExporter cellWidth(int cellWidth) {
        this.cellWidth = cellWidth;
        return this;
    }

    public FastExcelExporter headerRow(int headerRow) {
        this.headerRow = headerRow;
        return this;
    }

    public FastExcelExporter header(String ... header) {
        this.headers = new String[][]{header};
        return this;
    }

    public FastExcelExporter headers(String[] ... headers) {
        this.headers = headers;
        return this;
    }

    public FastExcelExporter column(String ... column) {
        this.columns = new String[][]{column};
        return this;
    }

    public FastExcelExporter columns(String[] ... columns) {
        this.columns = columns;
        return this;
    }

    public FastExcelExporter set(List<?> ... data) {
        this.data = data;
        return this;
    }

    public FastExcelExporter append(AppendMoreData ... append) {
        this.append = append;
        return this;
    }
}

