/*
 * Decompiled with CFR 0.152.
 */
package top.jfunc.common.excel;

import com.jfinal.plugin.activerecord.Model;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import top.jfunc.common.datetime.DatetimeUtils;
import top.jfunc.common.db.AppendMore;
import top.jfunc.common.db.bean.Record;
import top.jfunc.common.utils.BeanUtil;

public class ExportUtils {
    private static final int ROW_ACCESS_WINDOW_SIZE = 1000;
    private SXSSFWorkbook workbook = new SXSSFWorkbook(1000);
    private Sheet sheet = this.workbook.createSheet();
    private CellStyle style2;
    private CellStyle style;

    public ExportUtils(String[] headers) {
        this.sheet.setDefaultColumnWidth(20);
        this.style = this.workbook.createCellStyle();
        this.style.setFillForegroundColor((short)9);
        this.style.setFillPattern((short)1);
        this.style.setBorderBottom((short)1);
        this.style.setBorderLeft((short)1);
        this.style.setBorderRight((short)1);
        this.style.setBorderTop((short)1);
        this.style.setAlignment((short)2);
        Font font = this.workbook.createFont();
        font.setBoldweight((short)400);
        this.style.setFont(font);
        this.style2 = this.workbook.createCellStyle();
        this.style2.setFillForegroundColor((short)9);
        this.style2.setFillPattern((short)1);
        this.style2.setBorderBottom((short)1);
        this.style2.setBorderLeft((short)1);
        this.style2.setBorderRight((short)1);
        this.style2.setBorderTop((short)1);
        this.style2.setAlignment((short)1);
        this.style2.setVerticalAlignment((short)1);
        Font font2 = this.workbook.createFont();
        font2.setBoldweight((short)400);
        this.style2.setFont(font2);
        Row row = this.sheet.createRow(0);
        for (int i = 0; i < headers.length; i = (int)((short)(i + 1))) {
            Cell cell = row.createCell(i);
            cell.setCellStyle(this.style);
            cell.setCellType(1);
            cell.setCellValue(headers[i]);
        }
    }

    public void exportExcel(String[] columns, List<?> dataset, String pattern, int rowIndex) throws IOException {
        int index = rowIndex;
        Font font3 = this.workbook.createFont();
        font3.setColor((short)12);
        int size = dataset.size();
        for (int i = 0; i < size; ++i) {
            Row row = this.sheet.createRow(index++);
            Object data = dataset.get(i);
            for (int col = 0; col < columns.length; ++col) {
                Cell cell = row.createCell(col);
                Object value = this.getValue(data, columns, col);
                this.setCell(cell, value, pattern);
            }
            if (i == 0 || i % 1000 != 0) continue;
            ((SXSSFSheet)this.sheet).flushRows();
        }
        ((SXSSFSheet)this.sheet).flushRows();
    }

    private void setCell(Cell cell, Object value, String pattern) {
        cell.setCellStyle(this.style2);
        cell.setCellType(1);
        if (value == null) {
            cell.setCellType(1);
            cell.setCellValue("");
        } else if (value instanceof Integer) {
            cell.setCellType(0);
            cell.setCellValue((double)((Integer)value).intValue());
        } else if (value instanceof Long) {
            cell.setCellType(0);
            cell.setCellValue((double)((Long)value).longValue());
        } else if (value instanceof Double) {
            cell.setCellType(0);
            cell.setCellValue(((Double)value).doubleValue());
        } else if (value instanceof BigDecimal) {
            cell.setCellType(0);
            cell.setCellValue(((BigDecimal)value).doubleValue());
        } else if (value instanceof Date) {
            cell.setCellType(1);
            String date_str = DatetimeUtils.toStr((Date)((Date)value), (String)pattern);
            cell.setCellValue(date_str);
        } else {
            cell.setCellType(1);
            cell.setCellValue(value.toString());
        }
    }

    private Object getValue(Object data, String[] columns, int col) {
        Object value = null;
        String key = columns[col];
        value = data instanceof Model ? ((Model)data).get(key) : (data instanceof com.jfinal.plugin.activerecord.Record ? ((com.jfinal.plugin.activerecord.Record)data).get(key) : (data instanceof Record ? ((Record)data).get(key) : (data instanceof Map ? ((Map)data).get(key) : (data instanceof Object[] ? ((Object[])data)[col] : BeanUtil.get((Object)data, (String)key)))));
        return value;
    }

    public void write(OutputStream out) {
        try {
            this.workbook.write(out);
            out.flush();
            this.workbook.close();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public SXSSFWorkbook getSXSSFWorkbook() {
        return this.workbook;
    }

    public static <T> void exportToExcel(String[] headers, String[] columns, int pageNumber, int pageSize, OutputStream outputStream, AppendMore<T> appendMore) throws IOException {
        ExportUtils exportUtils = new ExportUtils(headers);
        int rowIndex = 1;
        List list = appendMore.getList(pageNumber, pageSize);
        while (null != list && list.size() > 0) {
            exportUtils.exportExcel(columns, list, "yyyy-MM-dd HH:mm:ss", rowIndex);
            rowIndex += list.size();
            list = appendMore.getList(++pageNumber, pageSize);
        }
        if (null != outputStream) {
            exportUtils.write(outputStream);
        }
    }
}

