/*
 * Decompiled with CFR 0.152.
 */
package top.jfunc.common.fastexcel;

import java.io.IOException;
import java.util.Objects;
import top.jfunc.common.fastexcel.Alignment;
import top.jfunc.common.fastexcel.Writer;

class Style {
    private final int valueFormatting;
    private final int font;
    private final int fill;
    private final int border;
    private final Alignment alignment;

    Style(Style original, int valueFormatting, int font, int fill, int border, Alignment alignment) {
        this.valueFormatting = valueFormatting == 0 && original != null ? original.valueFormatting : valueFormatting;
        this.font = font == 0 && original != null ? original.font : font;
        this.fill = fill == 0 && original != null ? original.fill : fill;
        this.border = border == 0 && original != null ? original.border : border;
        this.alignment = alignment == null && original != null ? original.alignment : alignment;
    }

    public int hashCode() {
        int hash = 5;
        hash = 29 * hash + this.valueFormatting;
        hash = 29 * hash + this.font;
        hash = 29 * hash + this.fill;
        hash = 29 * hash + this.border;
        hash = 29 * hash + Objects.hashCode(this.alignment);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Style other = (Style)obj;
        if (this.valueFormatting != other.valueFormatting) {
            return false;
        }
        if (this.font != other.font) {
            return false;
        }
        if (this.fill != other.fill) {
            return false;
        }
        if (this.border != other.border) {
            return false;
        }
        return Objects.equals(this.alignment, other.alignment);
    }

    void write(Writer w) throws IOException {
        w.append("<xf numFmtId=\"").append(this.valueFormatting).append("\" fontId=\"").append(this.font).append("\" fillId=\"").append(this.fill).append("\" borderId=\"").append(this.border).append("\" xfId=\"0\"");
        if (this.alignment == null) {
            w.append("/>");
        } else {
            w.append('>');
            this.alignment.write(w);
            w.append("</xf>");
        }
    }
}

