/*
 * Decompiled with CFR 0.152.
 */
package top.jfunc.common.excel.asyncexport;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import top.jfunc.common.datetime.DatetimeUtils;
import top.jfunc.common.db.DBHelper;
import top.jfunc.common.event.EventKit;
import top.jfunc.common.event.core.ApplicationEvent;
import top.jfunc.common.excel.asyncexport.ExportExcelBean;
import top.jfunc.common.excel.asyncexport.ExportExcelEvent;
import top.jfunc.common.utils.CommonUtil;

public class ExcelExportKit {
    private ExcelExportKit() {
    }

    public static Map<String, Object> createDownloadErrorJSONObject(String message) {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("status", 0);
        map.put("message", "\u5bfc\u51fa\u5931\u8d25\uff1a" + message);
        return map;
    }

    public static Map<String, Object> createDownloadBegingJSONObject(String taskId) {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("status", 1);
        map.put("message", "\u5bfc\u51fa\u5f00\u59cb,\u70b9\u51fb\u53bb\u4e0b\u8f7d,\u82e5\u6ca1\u6709\u5219\u7a0d\u540e\u5237\u65b0,\u4e5f\u53ef\u4ee5\u5230\"\u62a5\u8868\u4e2d\u5fc3/\u5bfc\u51fa\u6587\u4ef6\u4e0b\u8f7d\",\u4efb\u52a1\u53f7\u662f " + taskId);
        map.put("taskId", taskId);
        return map;
    }

    public static String generateFileName(String prefix) {
        String fileName = prefix + DatetimeUtils.toStr((Date)new Date(), (String)"yyyyMMddHHmmssSSS") + ".xlsx";
        return fileName;
    }

    public static Map<String, Object> postExportEvent(DBHelper helper, String sql, String[] headers, String[] columns, String filePath) {
        return ExcelExportKit.postExportEvent(helper, sql, headers, columns, filePath, null);
    }

    public static Map<String, Object> postExportEvent(DBHelper helper, String sql, String[] headers, String[] columns, String filePath, Runnable callback) {
        Map<String, Object> jo = null;
        try {
            String taskId = CommonUtil.getUUID();
            EventKit.post((ApplicationEvent)new ExportExcelEvent(new ExportExcelBean(helper, headers, columns, sql, filePath, callback)));
            jo = ExcelExportKit.createDownloadBegingJSONObject(taskId);
        }
        catch (Exception e) {
            jo = ExcelExportKit.createDownloadErrorJSONObject(e.getMessage());
        }
        return jo;
    }
}

