/*
 * Decompiled with CFR 0.152.
 */
package top.jfunc.common.fastexcel;

import java.io.IOException;
import java.util.Objects;
import top.jfunc.common.fastexcel.Writer;

class Alignment {
    private final String horizontal;
    private final String vertical;
    private final boolean wrapText;

    Alignment(String horizontal, String vertical, boolean wrapText) {
        this.horizontal = horizontal;
        this.vertical = vertical;
        this.wrapText = wrapText;
    }

    public int hashCode() {
        int hash = 5;
        hash = 59 * hash + Objects.hashCode(this.horizontal);
        hash = 59 * hash + Objects.hashCode(this.vertical);
        hash = 59 * hash + (this.wrapText ? 1 : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Alignment other = (Alignment)obj;
        if (!Objects.equals(this.horizontal, other.horizontal)) {
            return false;
        }
        if (!Objects.equals(this.vertical, other.vertical)) {
            return false;
        }
        return this.wrapText == other.wrapText;
    }

    void write(Writer w) throws IOException {
        w.append("<alignment");
        if (this.horizontal != null) {
            w.append(" horizontal=\"").append(this.horizontal).append('\"');
        }
        if (this.vertical != null) {
            w.append(" vertical=\"").append(this.vertical).append('\"');
        }
        if (this.wrapText) {
            w.append(" wrapText=\"").append(Boolean.toString(this.wrapText)).append('\"');
        }
        w.append("/>");
    }
}

