/*
 * Decompiled with CFR 0.152.
 */
package top.jfunc.common.fastexcel;

import java.io.IOException;
import java.util.Objects;
import top.jfunc.common.fastexcel.BorderElement;
import top.jfunc.common.fastexcel.Writer;

class Border {
    static final Border NONE = new Border(BorderElement.NONE, BorderElement.NONE, BorderElement.NONE, BorderElement.NONE, BorderElement.NONE);
    private final BorderElement left;
    private final BorderElement right;
    private final BorderElement top;
    private final BorderElement bottom;
    private final BorderElement diagonal;

    Border(BorderElement left, BorderElement right, BorderElement top, BorderElement bottom, BorderElement diagonal) {
        this.left = left;
        this.right = right;
        this.top = top;
        this.bottom = bottom;
        this.diagonal = diagonal;
    }

    static Border fromStyleAndColor(String style, String color) {
        BorderElement element = new BorderElement(style, color);
        return new Border(element, element, element, element, BorderElement.NONE);
    }

    public int hashCode() {
        int hash = 3;
        hash = 17 * hash + Objects.hashCode(this.left);
        hash = 17 * hash + Objects.hashCode(this.right);
        hash = 17 * hash + Objects.hashCode(this.top);
        hash = 17 * hash + Objects.hashCode(this.bottom);
        hash = 17 * hash + Objects.hashCode(this.diagonal);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Border other = (Border)obj;
        if (!Objects.equals(this.left, other.left)) {
            return false;
        }
        if (!Objects.equals(this.right, other.right)) {
            return false;
        }
        if (!Objects.equals(this.top, other.top)) {
            return false;
        }
        if (!Objects.equals(this.bottom, other.bottom)) {
            return false;
        }
        return Objects.equals(this.diagonal, other.diagonal);
    }

    void write(Writer w) throws IOException {
        w.append("<border>");
        this.left.write("left", w);
        this.right.write("right", w);
        this.top.write("top", w);
        this.bottom.write("bottom", w);
        this.diagonal.write("diagonal", w);
        w.append("</border>");
    }
}

