/*
 * Decompiled with CFR 0.152.
 */
package top.jfunc.common.fastexcel;

import java.io.IOException;
import java.util.Objects;
import top.jfunc.common.fastexcel.Writer;

class BorderElement {
    static final BorderElement NONE = new BorderElement(null, null);
    private final String style;
    private final String rgbColor;

    BorderElement(String style, String rgbColor) {
        this.style = style;
        this.rgbColor = rgbColor;
    }

    public int hashCode() {
        int hash = 3;
        hash = 41 * hash + Objects.hashCode(this.style);
        hash = 41 * hash + Objects.hashCode(this.rgbColor);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BorderElement other = (BorderElement)obj;
        if (!Objects.equals(this.style, other.style)) {
            return false;
        }
        return Objects.equals(this.rgbColor, other.rgbColor);
    }

    void write(String name, Writer w) throws IOException {
        w.append("<").append(name);
        if (this.style == null && this.rgbColor == null) {
            w.append("/>");
        } else {
            if (this.style != null) {
                w.append(" style=\"").append(this.style).append('\"');
            }
            w.append('>');
            if (this.rgbColor != null) {
                w.append("<color rgb=\"").append(this.rgbColor).append("/>");
            }
            w.append("</").append(name).append(">");
        }
    }
}

