/*
 * Decompiled with CFR 0.152.
 */
package top.jfunc.common.fastexcel;

import java.io.IOException;
import top.jfunc.common.fastexcel.CachedString;
import top.jfunc.common.fastexcel.Formula;
import top.jfunc.common.fastexcel.Range;
import top.jfunc.common.fastexcel.Writer;

class Cell {
    Object value;
    int style = 0;

    Cell() {
    }

    void write(Writer w, int r, int c) throws IOException {
        if (this.value != null || this.style != 0) {
            w.append("<c r=\"").append(Range.colToString(c)).append(r + 1).append('\"');
            if (this.style != 0) {
                w.append(" s=\"").append(this.style).append('\"');
            }
            if (this.value != null && !(this.value instanceof Formula)) {
                w.append(" t=\"").append(this.value instanceof CachedString ? (char)'s' : 'n').append('\"');
            }
            w.append(">");
            if (this.value instanceof Formula) {
                w.append("<f>").append(((Formula)this.value).getExpression()).append("</f>");
            } else if (this.value != null) {
                w.append("<v>");
                if (this.value instanceof CachedString) {
                    w.append(((CachedString)this.value).getIndex());
                } else if (this.value instanceof Integer) {
                    w.append((Integer)this.value);
                } else if (this.value instanceof Long) {
                    w.append((Long)this.value);
                } else if (this.value instanceof Double) {
                    w.append((Double)this.value);
                } else {
                    w.append(this.value.toString());
                }
                w.append("</v>");
            }
            w.append("</c>");
        }
    }
}

