/*
 * Decompiled with CFR 0.152.
 */
package top.jfunc.common.report;

import java.io.FileOutputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.jfunc.common.excel.ExportUtils;
import top.jfunc.common.report.AbstractExportUploadService;

public abstract class AbstractExportUploadExcelService<T>
extends AbstractExportUploadService<T> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractExportUploadExcelService.class);

    @Override
    protected void export(String fileName, String filePath) {
        try (FileOutputStream stream = new FileOutputStream(filePath);){
            ExportUtils.exportToExcel(this.getHeaders(), this.getColumns(), 1, PAGE_SIZE, stream, this);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    protected abstract String[] getHeaders();

    protected abstract String[] getColumns();
}

