/*
 * Decompiled with CFR 0.152.
 */
package top.jiaojinxin.jln.event;

import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.InsufficientCapacityException;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextClosedEvent;
import top.jiaojinxin.jln.event.Event;
import top.jiaojinxin.jln.event.EventPublisher;

public abstract class AbstractEventPublisher
implements EventPublisher,
ApplicationRunner,
ApplicationListener<ContextClosedEvent>,
EventHandler<DisruptorEvent> {
    private static final String DASHED = "-";
    private final Disruptor<DisruptorEvent> disruptor;
    private final RingBuffer<DisruptorEvent> ringBuffer;
    private boolean disruptorEnd = true;

    protected AbstractEventPublisher(int ringBufferSize, String threadNamePrefix, ProducerType producerType, WaitStrategy waitStrategy) {
        this.disruptor = new Disruptor(DisruptorEvent::new, ringBufferSize, (ThreadFactory)new NameThreadFactory(threadNamePrefix), producerType, waitStrategy);
        this.disruptor.handleEventsWith(new EventHandler[]{this});
        this.ringBuffer = this.disruptor.getRingBuffer();
    }

    @Override
    public void publish(Event event) {
        if (event == null || this.disruptorEnd) {
            return;
        }
        try {
            long next = this.ringBuffer.tryNext();
            DisruptorEvent disruptorEvent = (DisruptorEvent)this.ringBuffer.get(next);
            disruptorEvent.setEvent(event);
            this.ringBuffer.publish(next);
        }
        catch (InsufficientCapacityException e) {
            this.doPublish(event);
        }
    }

    public void onEvent(DisruptorEvent event, long sequence, boolean endOfBatch) {
        this.doPublish(event.getEvent());
    }

    public void run(ApplicationArguments args) {
        this.disruptor.start();
        this.disruptorEnd = false;
    }

    public void onApplicationEvent(ContextClosedEvent event) {
        this.disruptorEnd = true;
        this.disruptor.shutdown();
    }

    protected abstract void doPublish(Event var1);

    private static class NameThreadFactory
    implements ThreadFactory {
        private final AtomicInteger index = new AtomicInteger(0);
        private final String threadNamePrefix;

        private NameThreadFactory(String threadNamePrefix) {
            this.threadNamePrefix = threadNamePrefix;
        }

        @Override
        public Thread newThread(Runnable r) {
            String formatTemplate = this.threadNamePrefix.endsWith(AbstractEventPublisher.DASHED) ? "%s%s" : "%s-%s";
            return new Thread(r, String.format(formatTemplate, this.threadNamePrefix, this.index.getAndIncrement()));
        }
    }

    public static class DisruptorEvent {
        private Event event;

        public Event getEvent() {
            return this.event;
        }

        public void setEvent(Event event) {
            this.event = event;
        }
    }
}

