/*
 * Decompiled with CFR 0.152.
 */
package top.jiaojinxin.sign.util;

import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.regex.Pattern;
import org.springframework.util.StringUtils;
import top.jiaojinxin.core.exception.BizException;
import top.jiaojinxin.core.exception.SysException;
import top.jiaojinxin.sign.ClientPublicKeyHolder;
import top.jiaojinxin.sign.model.SignDTO;
import top.jiaojinxin.sign.properties.SignProperties;

public class SignUtil {
    private static final Pattern TIMESTAMP_PATTERN = Pattern.compile("^\\d+$");
    private static final String SIGNATURE_ALGORITHM = "SHA256withRSA";
    private static final String RSA_ALGORITHM = "RSA";
    private static SignProperties signProperties;
    private static ClientPublicKeyHolder clientPublicKeyHolder;

    private SignUtil() {
    }

    public static String sign(SignDTO signDTO) {
        SignUtil.validated(signDTO);
        PrivateKey privateKey = SignUtil.privateKey(signProperties.getClientPrivateKey());
        byte[] result = SignUtil.sign(signDTO.getByteArray(), privateKey);
        return Base64.getEncoder().encodeToString(result);
    }

    public static boolean verify(SignDTO signDTO, String signValue) {
        SignUtil.validated(signDTO);
        String publicKeyStr = clientPublicKeyHolder.clientPublicKey(signDTO.getClientCode());
        PublicKey publicKey = SignUtil.publicKey(publicKeyStr);
        byte[] signValueByteArray = Base64.getDecoder().decode(signValue);
        return SignUtil.verify(signDTO.getByteArray(), signValueByteArray, publicKey);
    }

    private static byte[] sign(byte[] data, PrivateKey privateKey) {
        try {
            Signature signature = SignUtil.getSignature();
            signature.initSign(privateKey);
            signature.update(data);
            return signature.sign();
        }
        catch (InvalidKeyException | SignatureException e) {
            throw new SysException(signProperties.getExceptionCode().getSignError(), (Throwable)e);
        }
    }

    private static boolean verify(byte[] data, byte[] signValue, PublicKey publicKey) {
        try {
            Signature signature = SignUtil.getSignature();
            signature.initVerify(publicKey);
            signature.update(data);
            return signature.verify(signValue);
        }
        catch (InvalidKeyException | SignatureException e) {
            throw new SysException(signProperties.getExceptionCode().getVerifyError(), (Throwable)e);
        }
    }

    private static void validated(SignDTO signDTO) {
        if (signDTO != null && StringUtils.hasText((String)signDTO.getClientCode()) && StringUtils.hasText((String)signDTO.getTimestamp()) && TIMESTAMP_PATTERN.matcher(signDTO.getTimestamp()).find() && StringUtils.hasText((String)signDTO.getUid()) && StringUtils.hasText((String)signDTO.getContent()) && StringUtils.hasText((String)signDTO.getAlgorithm()) && StringUtils.hasText((String)signDTO.getSalt())) {
            return;
        }
        throw new BizException(signProperties.getExceptionCode().getIllegalRequest());
    }

    private static Signature getSignature() {
        try {
            return Signature.getInstance(SIGNATURE_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SysException(signProperties.getExceptionCode().getNoSuchAlgorithm(), (Throwable)e);
        }
    }

    private static PrivateKey privateKey(String privateKey) {
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(SignUtil.decodeSecretKey(privateKey), RSA_ALGORITHM);
        try {
            return SignUtil.keyFactory().generatePrivate(keySpec);
        }
        catch (InvalidKeySpecException e) {
            throw new SysException(signProperties.getExceptionCode().getGeneratePrivateKeyError(), (Throwable)e);
        }
    }

    private static PublicKey publicKey(String publicKey) {
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(SignUtil.decodeSecretKey(publicKey), RSA_ALGORITHM);
        try {
            return SignUtil.keyFactory().generatePublic(keySpec);
        }
        catch (InvalidKeySpecException e) {
            throw new SysException(signProperties.getExceptionCode().getGeneratePublicKeyError(), (Throwable)e);
        }
    }

    private static KeyFactory keyFactory() {
        try {
            return KeyFactory.getInstance(RSA_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SysException(signProperties.getExceptionCode().getNoSuchAlgorithm(), (Throwable)e);
        }
    }

    private static byte[] decodeSecretKey(String secretKey) {
        return Base64.getDecoder().decode(secretKey);
    }

    public static void setSignProperties(SignProperties signProperties) {
        SignUtil.signProperties = signProperties;
    }

    public static void setClientPublicKeyHolder(ClientPublicKeyHolder clientPublicKeyHolder) {
        SignUtil.clientPublicKeyHolder = clientPublicKeyHolder;
    }
}

