/*
 * Decompiled with CFR 0.152.
 */
package top.jlpan;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import top.jlpan.config.GenConfig;
import top.jlpan.data.TableServiceImpl;
import top.jlpan.gen.ClassPathTemplateGen;
import top.jlpan.model.Table;

public class GenMain {
    private static String root = System.getProperty("user.dir");
    private static String author = "panliang";
    private static String namespace = "xxx.xxx.xxx.xxx";
    private static String version = "1.0";
    private static String origin = "CODE_OLD_AND_NEW_DISTINCTION_FLAG";
    private static String entityPath = "\\farm-service\\src\\main\\java\\com\\jimi\\farm\\upms\\entity\\{a}.java";
    private static String entityTemplate = "vm/entity.java.vm";
    private static String mapperPath = "\\farm-service\\src\\main\\java\\com\\jimi\\farm\\upms\\dao\\{a}Mapper.java";
    private static String mapperTemplate = "vm/mapper.java.vm";
    private static String xmlPath = "\\farm-service\\src\\main\\resources\\mapper\\{a}Mapper.xml";
    private static String xmlTemplate = "vm/mapper.xml.vm";
    private static HashMap<String, Object> map = new HashMap();

    public static void main(String[] args) throws IOException {
        HashMap<String, String> table = new HashMap<String, String>();
        table.put("t_user", "User");
        GenConfig.url = "jdbc:mysql://127.0.0.1:3306/gen?usdeUnicode=true&characterEncoding=UTF-8&serverTimezone=UTC";
        GenConfig.username = "root";
        GenConfig.password = "root";
        GenConfig.prefix = "t_";
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        map.put("createDate", format.format(new Date()));
        map.put("author", author);
        map.put("version", version);
        map.put("namespace", namespace);
        for (Map.Entry entry : table.entrySet()) {
            GenMain.genAll((String)entry.getKey(), (String)entry.getValue());
        }
    }

    static void genAll(String tableName, String modelName) throws IOException {
        GenMain.genEntity(tableName, modelName);
        GenMain.genMapper(tableName, modelName);
        GenMain.genXml(tableName, modelName);
    }

    static void genMapper(String tableName, String modelName) {
        String path = GenMain.getPath(mapperPath, modelName);
        ClassPathTemplateGen mapperGen = new ClassPathTemplateGen(mapperTemplate);
        Table table = new TableServiceImpl().selectTableByName(tableName);
        mapperGen.initData(map, table);
        GenMain.writeFile(path, mapperGen.gen());
    }

    static void genEntity(String tableName, String modelName) {
        Table table = new TableServiceImpl().selectTableByName(tableName);
        String path = GenMain.getPath(entityPath, modelName);
        ClassPathTemplateGen entityGen = new ClassPathTemplateGen(entityTemplate);
        entityGen.initData(map, table);
        GenMain.writeFile(path, entityGen.gen());
    }

    static void genXml(String tableName, String modelName) {
        Table table = new TableServiceImpl().selectTableByName(tableName);
        String path = GenMain.getPath(xmlPath, modelName);
        ClassPathTemplateGen xmlGen = new ClassPathTemplateGen(xmlTemplate);
        xmlGen.initData(map, table);
        GenMain.writeFile(path, xmlGen.gen());
    }

    static void writeFile(String path, StringWriter sw) {
        try {
            String newString = sw.toString();
            System.out.println("\u8def\u5f84:" + path + " \u751f\u6210\u4e2d....");
            File file = new File(path);
            if (!file.exists()) {
                System.out.println("\u6587\u4ef6\u8def\u5f84:" + path + " \u4e0d\u5b58\u5728,\u6b63\u5728\u65b0\u5efa...");
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                    file.createNewFile();
                }
            } else {
                while (true) {
                    System.out.println("\u6587\u4ef6\u8def\u5f84:" + path + "\u5df2\u5b58\u5728,\u9009\u62e9\u8986\u76d6,\u53d6\u6d88,\u6839\u636e\u6807\u8bc6\u5408\u5e76\u6216\u91cd\u547d\u540d\uff1f");
                    System.out.println("1:\u8986\u76d6 2:\u53d6\u6d88 3:\u5408\u5e76 4:\u91cd\u547d\u540d");
                    Scanner scanner = new Scanner(System.in);
                    String an = scanner.nextLine();
                    if ("1".equals(an)) {
                        System.out.println("\u8986\u76d6\u4e2d...");
                        file.delete();
                        System.out.println("\u8986\u76d6\u5b8c\u6bd5\uff01");
                        break;
                    }
                    if ("2".equals(an)) {
                        System.out.println("\u8df3\u8fc7\u6267\u884c\uff01");
                        return;
                    }
                    if ("3".equals(an)) {
                        FileInputStream stream = new FileInputStream(file);
                        int size = stream.available();
                        byte[] buffer = new byte[size];
                        stream.read(buffer);
                        stream.close();
                        String oldString = new String(buffer);
                        int oldIndex = oldString.lastIndexOf(origin);
                        int newIndex = newString.lastIndexOf(origin);
                        if (oldIndex == -1 || newIndex == -1) {
                            System.out.println("\u4e0d\u5b58\u5728" + origin + ",\u8df3\u8fc7\u6267\u884c\uff01");
                            return;
                        }
                        stream.close();
                        String oldNeed = oldString.substring(oldIndex + origin.length());
                        String newNeed = newString.substring(0, newIndex + origin.length() + 1);
                        newString = newNeed + oldNeed;
                        System.out.println("\u5df2\u5408\u5e76\uff01");
                        break;
                    }
                    if ("4".equals(an)) {
                        int index = path.lastIndexOf(".");
                        String fileName = path.substring(index);
                        String head = path.substring(0, index);
                        String copy = head + "Copy" + fileName;
                        file = new File(copy);
                        System.out.println("\u5df2\u91cd\u547d\u540d\uff01");
                        break;
                    }
                    System.out.println("\u8f93\u5165\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff01");
                }
            }
            FileOutputStream out = new FileOutputStream(file);
            ((OutputStream)out).write(newString.getBytes());
            out.flush();
            ((OutputStream)out).close();
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }

    static String getPath(String path, String model) {
        return root + path.replace("{a}", model);
    }
}

