/*
 * Decompiled with CFR 0.152.
 */
package top.jlpan.data;

import java.util.ArrayList;
import java.util.List;
import top.jlpan.data.ITableService;
import top.jlpan.model.Column;
import top.jlpan.model.Table;
import top.jlpan.utils.JdbcUtils;
import top.jlpan.utils.TableUtils;

public class TableServiceImpl
implements ITableService {
    @Override
    public Table selectTableByName(String tableName) {
        String sql = "select table_name, table_comment, create_time, update_time from information_schema.tables where table_schema = (select database()) and table_name = ?";
        ArrayList<Table> tables = JdbcUtils.executeQuery(sql, Table.class, tableName);
        if (null != tables && tables.size() != 1) {
            return null;
        }
        Table table = (Table)tables.get(0);
        List<Column> columnList = this.selectTableColumnsByName(tableName);
        return TableUtils.tableTransJava(table, columnList);
    }

    @Override
    public List<Column> selectTableColumnsByName(String tableName) {
        String sql = "select column_name, data_type, column_comment, extra from information_schema.columns where table_name = ? and table_schema = (select database()) order by ordinal_position";
        ArrayList<Column> columnList = JdbcUtils.executeQuery(sql, Column.class, tableName);
        return TableUtils.columnTransJava(columnList);
    }
}

