/*
 * Decompiled with CFR 0.152.
 */
package top.jlpan.gen;

import java.util.HashMap;
import java.util.Map;
import org.apache.velocity.VelocityContext;
import top.jlpan.config.VelocityInitializer;
import top.jlpan.config.enums.InitType;
import top.jlpan.gen.Gen;
import top.jlpan.model.Table;

public abstract class AbstractTemplateGen
implements Gen {
    private HashMap<String, Object> fillMap;
    private Table table;
    VelocityContext context = new VelocityContext();

    AbstractTemplateGen() {
    }

    abstract InitType getType();

    public void initData(HashMap<String, Object> fillMap, Table table) {
        this.fillMap = fillMap == null ? new HashMap(1) : fillMap;
        this.table = table == null ? new Table() : table;
        this.initResource();
        this.initTable();
        this.initMap();
    }

    private void initResource() {
        if (this.getType() == InitType.CLASSPATH) {
            VelocityInitializer.initClassPathResource();
        }
        if (this.getType() == InitType.ABSOLUTE) {
            VelocityInitializer.initAbsoluteResource();
        }
        if (this.getType() == InitType.STREAM) {
            VelocityInitializer.initStreamResource();
        }
    }

    private void initTable() {
        this.context.put("tableName", (Object)this.table.getTableName());
        this.context.put("tableComment", (Object)this.table.getTableComment());
        this.context.put("primaryKey", (Object)this.table.getPrimaryKey());
        this.context.put("classCapName", (Object)this.table.getClassCapName());
        this.context.put("classLowName", (Object)this.table.getClassLowName());
        this.context.put("columns", this.table.getColumns());
    }

    private void initMap() {
        for (Map.Entry<String, Object> entry : this.fillMap.entrySet()) {
            this.context.put(entry.getKey(), entry.getValue());
        }
    }
}

