/*
 * Decompiled with CFR 0.152.
 */
package top.jlpan.utils;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import top.jlpan.data.jdbc.JdbcConnection;

public class JdbcUtils {
    public static <T> ArrayList<T> executeQuery(String sql, Class<T> obj, Object ... param) {
        Connection conn = JdbcConnection.getConnection();
        try {
            PreparedStatement st = conn.prepareStatement(sql);
            if (param != null) {
                for (int i = 0; i < param.length; ++i) {
                    st.setObject(i + 1, param[i]);
                }
            }
            ResultSet rs = st.executeQuery();
            ArrayList<T> list = JdbcUtils.putResult(rs, obj);
            conn.close();
            return list;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static <T> ArrayList<T> putResult(ResultSet rs, Class<T> obj) {
        try {
            ArrayList<T> arrayList = new ArrayList<T>();
            ResultSetMetaData metaData = rs.getMetaData();
            int count = metaData.getColumnCount();
            while (rs.next()) {
                T newInstance = obj.newInstance();
                for (int i = 1; i <= count; ++i) {
                    Class<Object> type;
                    String name = metaData.getColumnName(i).toLowerCase();
                    name = JdbcUtils.toJavaField(name);
                    String substring = name.substring(0, 1);
                    String replace = name.replaceFirst(substring, substring.toUpperCase());
                    try {
                        type = obj.getDeclaredField(name).getType();
                    }
                    catch (NoSuchFieldException e) {
                        continue;
                    }
                    Method method = obj.getMethod("set" + replace, type);
                    if (type.isAssignableFrom(String.class)) {
                        method.invoke(newInstance, rs.getString(i));
                        continue;
                    }
                    if (type.isAssignableFrom(Integer.TYPE) || type.isAssignableFrom(Integer.class)) {
                        method.invoke(newInstance, rs.getInt(i));
                        continue;
                    }
                    if (type.isAssignableFrom(Boolean.class) || type.isAssignableFrom(Boolean.TYPE)) {
                        method.invoke(newInstance, rs.getBoolean(i));
                        continue;
                    }
                    if (type.isAssignableFrom(Date.class)) {
                        method.invoke(newInstance, rs.getDate(i));
                        continue;
                    }
                    if (!type.isAssignableFrom(BigDecimal.class)) continue;
                    method.invoke(newInstance, rs.getBigDecimal(i));
                }
                arrayList.add(newInstance);
            }
            return arrayList;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String toJavaField(String str) {
        String[] split = str.split("_");
        StringBuilder builder = new StringBuilder();
        builder.append(split[0]);
        if (split.length > 1) {
            for (int i = 1; i < split.length; ++i) {
                String string = split[i];
                String substring = string.substring(0, 1);
                split[i] = string.replaceFirst(substring, substring.toUpperCase());
                builder.append(split[i]);
            }
        }
        return builder.toString();
    }
}

