/*
 * Decompiled with CFR 0.152.
 */
package top.jlpan.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import top.jlpan.config.GenConfig;
import top.jlpan.model.Column;
import top.jlpan.model.Table;

public class TableUtils {
    private static final String SEPARATOR = "_";
    private static final Map<String, String> JAVA_TYPE_MAP = new HashMap<String, String>();

    public static List<Column> columnTransJava(List<Column> columns) {
        ArrayList<Column> columnList = new ArrayList<Column>();
        for (Column column : columns) {
            String javaName = TableUtils.toUnderScoreCase(column.getColumnName());
            column.setAttrLowName(javaName);
            String capName = TableUtils.capToCap(javaName);
            column.setAttrCapName(capName);
            String attrType = JAVA_TYPE_MAP.get(column.getDataType());
            column.setAttrType(attrType);
            columnList.add(column);
        }
        return columnList;
    }

    public static Table tableTransJava(Table table, List<Column> columns) {
        String tableName = table.getTableName();
        tableName = tableName.substring(GenConfig.prefix.length());
        String className = TableUtils.toUnderScoreCase(tableName);
        String classCapName = TableUtils.capToCap(className);
        table.setClassCapName(classCapName);
        table.setClassLowName(className);
        table.setColumns(columns);
        table.setPrimaryKey(columns.get(0));
        return table;
    }

    private static String toUnderScoreCase(String param) {
        if (param == null || "".equals(param.trim())) {
            return "";
        }
        StringBuilder sb = new StringBuilder(param);
        Matcher mc = Pattern.compile(SEPARATOR).matcher(param);
        int i = 0;
        while (mc.find()) {
            int position = mc.end() - i++;
            sb.replace(position - 1, position + 1, sb.substring(position, position + 1).toUpperCase());
        }
        return sb.toString();
    }

    private static String capToCap(String str) {
        if (Character.isUpperCase(str.charAt(0))) {
            return str;
        }
        return Character.toUpperCase(str.charAt(0)) + str.substring(1);
    }

    private static void initJavaTypeMap() {
        JAVA_TYPE_MAP.put("tinyint", "Integer");
        JAVA_TYPE_MAP.put("smallint", "Integer");
        JAVA_TYPE_MAP.put("mediumint", "Integer");
        JAVA_TYPE_MAP.put("int", "Integer");
        JAVA_TYPE_MAP.put("integer", "integer");
        JAVA_TYPE_MAP.put("bigint", "Long");
        JAVA_TYPE_MAP.put("float", "Float");
        JAVA_TYPE_MAP.put("double", "Double");
        JAVA_TYPE_MAP.put("decimal", "BigDecimal");
        JAVA_TYPE_MAP.put("bit", "Boolean");
        JAVA_TYPE_MAP.put("char", "String");
        JAVA_TYPE_MAP.put("varchar", "String");
        JAVA_TYPE_MAP.put("tinytext", "String");
        JAVA_TYPE_MAP.put("text", "String");
        JAVA_TYPE_MAP.put("mediumtext", "String");
        JAVA_TYPE_MAP.put("longtext", "String");
        JAVA_TYPE_MAP.put("time", "Date");
        JAVA_TYPE_MAP.put("date", "Date");
        JAVA_TYPE_MAP.put("datetime", "Date");
        JAVA_TYPE_MAP.put("timestamp", "Date");
        JAVA_TYPE_MAP.put("decimal ", "BigDecimal");
    }

    static {
        TableUtils.initJavaTypeMap();
    }
}

