/*
 * Decompiled with CFR 0.152.
 */
package top.jpower.jpower.module.common.utils;

import cn.hutool.core.util.URLUtil;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.security.Key;
import java.util.Date;
import java.util.Map;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.http.HttpServletRequest;
import lombok.NonNull;
import top.jpower.jpower.module.common.utils.Fc;
import top.jpower.jpower.module.common.utils.SpringUtil;
import top.jpower.jpower.module.common.utils.StringUtil;
import top.jpower.jpower.module.common.utils.WebUtil;
import top.jpower.jpower.module.common.utils.constants.TokenConstant;
import top.jpower.jpower.module.properties.AuthProperties;

public class JwtUtil {
    public static Integer AUTH_LENGTH = "jpower".length() + 1;

    public static Claims parseJwt(@NonNull String token) {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        if (Fc.isBlank((CharSequence)token)) {
            return null;
        }
        try {
            return (Claims)Jwts.parser().setSigningKey(TokenConstant.JWT_BASE64_SECURITY).parseClaimsJws(token).getBody();
        }
        catch (ExpiredJwtException e) {
            return null;
        }
    }

    public static String parsingToken(@NonNull String authToken) {
        if (authToken == null) {
            throw new NullPointerException("authToken is marked non-null but is null");
        }
        if (StringUtil.isNotBlank((CharSequence)authToken) && authToken.length() > AUTH_LENGTH && authToken.startsWith("jpower")) {
            authToken = authToken.substring(AUTH_LENGTH);
            return authToken;
        }
        return "";
    }

    public static String getToken(HttpServletRequest request) {
        String cookieVal;
        if (Fc.isNull((Object)request)) {
            return null;
        }
        String auth = request.getHeader("jpower-auth");
        if (StringUtil.isNotBlank((CharSequence)auth)) {
            return JwtUtil.parsingToken(auth);
        }
        AuthProperties properties = (AuthProperties)SpringUtil.getBean(AuthProperties.class);
        if (Fc.notNull((Object)properties) && properties.getCookie().booleanValue() && Fc.isNotBlank((CharSequence)(cookieVal = WebUtil.getCookieVal((HttpServletRequest)request, (String)"jpower-auth")))) {
            return cookieVal;
        }
        String parameter = request.getParameter("jpower-auth");
        if (StringUtil.isNotBlank((CharSequence)parameter)) {
            return URLUtil.decode((String)parameter);
        }
        return "";
    }

    public static String createJwt(Map<String, Object> param, long expire) {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;
        long nowMillis = System.currentTimeMillis();
        Date now = new Date(nowMillis);
        SecretKeySpec signingKey = new SecretKeySpec(TokenConstant.JWT_BASE64_SECURITY, signatureAlgorithm.getJcaName());
        JwtBuilder builder = Jwts.builder().setHeaderParam("Type", (Object)"JsonWebToken").signWith(signatureAlgorithm, (Key)signingKey);
        param.forEach((arg_0, arg_1) -> ((JwtBuilder)builder).claim(arg_0, arg_1));
        Date exp = new Date(nowMillis + expire * 1000L);
        builder.setExpiration(exp).setNotBefore(now);
        return builder.compact();
    }
}

