/*
 * Decompiled with CFR 0.152.
 */
package top.jpower.jpower.module.common.utils;

import cn.hutool.core.codec.Base64Decoder;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.date.DateUnit;
import io.jsonwebtoken.Claims;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.jpower.jpower.module.common.auth.RoleConstant;
import top.jpower.jpower.module.common.auth.UserInfo;
import top.jpower.jpower.module.common.support.EnvBeanUtil;
import top.jpower.jpower.module.common.utils.BeanUtil;
import top.jpower.jpower.module.common.utils.DateUtil;
import top.jpower.jpower.module.common.utils.Fc;
import top.jpower.jpower.module.common.utils.JwtUtil;
import top.jpower.jpower.module.common.utils.StringUtil;
import top.jpower.jpower.module.common.utils.WebUtil;
import top.jpower.jpower.module.common.utils.constants.CharsetKit;

public class ShieldUtil {
    private static final Logger log = LoggerFactory.getLogger(ShieldUtil.class);
    private static final String REQUEST_USER_SESSION = "request_user_session";
    private static final String REQUEST_USER_TOKEN = "request_user_token";

    public static UserInfo getUser() {
        long bet;
        HttpServletRequest request = WebUtil.getRequest();
        String token = JwtUtil.getToken(request);
        if (Fc.isNull((Object)request) || Fc.isBlank((CharSequence)token)) {
            return null;
        }
        UserInfo userInfo = (UserInfo)request.getSession().getAttribute(REQUEST_USER_SESSION);
        String sessionToken = (String)request.getSession().getAttribute(REQUEST_USER_TOKEN);
        if ((Fc.isNull((Object)userInfo) || !Fc.equalsValue((CharSequence)sessionToken, (CharSequence)token)) && Fc.notNull((Object)(userInfo = ShieldUtil.getUser(request))) && (bet = DateUtil.between((Date)DateUtil.date(), (Date)ShieldUtil.getClaims(request).getExpiration(), (DateUnit)DateUnit.SECOND, (boolean)false)) > 0L) {
            request.getSession().setMaxInactiveInterval((int)bet);
            request.getSession().setAttribute(REQUEST_USER_SESSION, (Object)userInfo);
            request.getSession().setAttribute(REQUEST_USER_TOKEN, (Object)token);
        }
        return userInfo;
    }

    public static UserInfo getUser(Claims claims) {
        UserInfo user = new UserInfo();
        if (Fc.notNull((Object)claims)) {
            user = (UserInfo)BeanUtil.toBean((Object)claims, UserInfo.class);
        }
        return user.isEmpty() ? null : user;
    }

    public static UserInfo getUser(HttpServletRequest request) {
        return ShieldUtil.getUser(ShieldUtil.getClaims(request));
    }

    public static boolean isRoot() {
        return Fc.contains(ShieldUtil.getUserRole(), (Object)RoleConstant.ROOT_ID);
    }

    public static Long getUserId() {
        UserInfo user = ShieldUtil.getUser();
        return null == user ? null : user.getUserId();
    }

    public static Long getOrgId() {
        UserInfo user = ShieldUtil.getUser();
        return null == user ? null : user.getOrgId();
    }

    public static String getLoginId() {
        UserInfo user = ShieldUtil.getUser();
        return Fc.isNull((Object)user) ? "" : user.getLoginId();
    }

    public static String getUserName() {
        UserInfo user = ShieldUtil.getUser();
        return Fc.isNull((Object)user) ? "" : user.getUserName();
    }

    public static List<Long> getUserRole() {
        UserInfo user = ShieldUtil.getUser();
        if (Fc.isNull((Object)user)) {
            return ListUtil.of((Object[])new Long[]{RoleConstant.ANONYMOUS_ID});
        }
        return user.getRoleIds();
    }

    public static String getTenantCode() {
        return ShieldUtil.getTenantCode(WebUtil.getRequest());
    }

    public static String getTenantCode(HttpServletRequest request) {
        if (!EnvBeanUtil.getTenantEnable().booleanValue()) {
            return "";
        }
        if (Fc.isNull((Object)request)) {
            log.warn("HttpServletRequest\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u79df\u6237");
            return "";
        }
        UserInfo user = ShieldUtil.getUser(request);
        if (Fc.isNull((Object)user)) {
            String tenantCode = "";
            if (Fc.notNull((Object)request)) {
                String code = request.getParameter("tenantCode");
                tenantCode = Fc.isBlank((CharSequence)code) ? request.getHeader("Tenant-Code") : code;
            }
            return tenantCode;
        }
        return user.getTenantCode();
    }

    public static String getClientCode() {
        UserInfo user = ShieldUtil.getUser();
        return Fc.isNull((Object)user) ? "" : user.getClientCode();
    }

    public static Claims getClaims(HttpServletRequest request) {
        return JwtUtil.parseJwt(JwtUtil.getToken(request));
    }

    public static String[] getClientInfo() {
        String header = Objects.requireNonNull(WebUtil.getRequest()).getHeader("Authorization");
        if (!(header = Fc.toStr((Object)header).replace("Basic%20", "Basic ")).startsWith("Basic ")) {
            throw new IllegalArgumentException("\u8bf7\u6c42\u5934\u4e2d\u6ca1\u6709\u5ba2\u6237\u7aef\u4fe1\u606f");
        }
        String decodeBasic = StringUtil.subAfter((CharSequence)header, (CharSequence)"Basic ", (boolean)false);
        return ShieldUtil.extractClient(decodeBasic);
    }

    public static String[] extractClient(String decodeBasic) {
        String token = new String(Base64Decoder.decode((byte[])decodeBasic.getBytes(CharsetKit.UTF_8)), CharsetKit.UTF_8);
        if (StringUtil.contains((CharSequence)token, (char)':') && !StringUtil.startWith((CharSequence)token, (char)':') && !StringUtil.endWith((CharSequence)token, (char)':')) {
            String[] clients = new String[]{StringUtil.subBefore((CharSequence)token, (CharSequence)":", (boolean)false), StringUtil.subAfter((CharSequence)token, (CharSequence)":", (boolean)false)};
            return clients;
        }
        throw new IllegalArgumentException("\u65e0\u6548\u7684\u57fa\u672c\u8eab\u4efd\u9a8c\u8bc1\u4ee4\u724c");
    }

    public static String getClientCodeFromHeader() {
        String[] tokens = ShieldUtil.getClientInfo();
        assert (tokens.length == 2);
        return tokens[0];
    }

    public static String getClientSecretFromHeader() {
        String[] tokens = ShieldUtil.getClientInfo();
        assert (tokens.length == 2);
        return tokens[1];
    }
}

