/*
 * Decompiled with CFR 0.152.
 */
package top.jpower.jpower.module.common.utils;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.jpower.jpower.module.common.utils.WebUtil;

public class SqlInjectionUtil {
    private static final Logger logger = LoggerFactory.getLogger(SqlInjectionUtil.class);
    private static final String[] SENSITIVE_CHAR = new String[]{"'", "--", "|", "<", ">", " or ", " xor ", " and ", "&lt;", "&gt;", "&#34", "&#349", "%27"};
    public static final String[] SQL_CHAR = new String[]{"delete", "drop", "create", "select", "truncate", "update", "insert", "alter", "declare", "xp_cmdshell", "exec", "execute"};
    private static final String[] JS_CHAR = new String[]{"<img", "%3cimg", "<script", "%3cscript", "alert", "console", "document.location", "window.location", "javascript"};

    public static String filter(String str) {
        String str0 = str;
        if (StringUtils.isBlank((CharSequence)str)) {
            return "";
        }
        for (String chars0 : SENSITIVE_CHAR) {
            if (!str.toLowerCase().contains(chars0)) continue;
            str = str.replaceAll("(?i)" + chars0, "");
        }
        for (String keys0 : SQL_CHAR) {
            if (!str.toLowerCase().contains(keys0 + " ")) continue;
            str = str.replaceAll("(?i)" + keys0, "");
        }
        for (String keys0 : JS_CHAR) {
            if (!str.toLowerCase().replaceAll("\\s", "").contains(keys0)) continue;
            str = str.replaceAll("(?i)" + keys0, "");
        }
        if (!str0.equals(str)) {
            logger.warn("\u68c0\u6d4b\u5230\u975e\u6cd5\u5b57\u7b26\u5e76\u5df2\u8fc7\u6ee4\u3002\n\u8bf7\u6c42\u5730\u5740\uff1a{}\n\u539f\u5b57\u7b26\uff1a{} \n\u65b0\u5b57\u7b26\uff1a{}", new Object[]{WebUtil.getRequest().getServletPath(), str0, str});
        }
        return str;
    }

    public static Map<String, Object> filterMap(Map<String, Object> map, boolean filterKey) {
        HashMap<String, Object> mapNew = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (filterKey) {
                if (null != entry.getKey() && null != entry.getValue()) {
                    mapNew.put(SqlInjectionUtil.filter(entry.getKey()), SqlInjectionUtil.filter(entry.getValue().toString()));
                    continue;
                }
                if (null == entry.getKey()) continue;
                mapNew.put(SqlInjectionUtil.filter(entry.getKey()), null);
                continue;
            }
            if (null != entry.getValue()) {
                mapNew.put(entry.getKey(), SqlInjectionUtil.filter(entry.getValue().toString()));
                continue;
            }
            mapNew.put(entry.getKey(), null);
        }
        return mapNew;
    }

    public static String filterParameters(String url, Map<String, String[]> paras) {
        String value = "";
        for (Map.Entry<String, String[]> entry : paras.entrySet()) {
            String[] values = entry.getValue();
            if (null == values) {
                value = "";
            } else if (values.length > 1) {
                for (int i = 0; i < values.length; ++i) {
                    value = values[i] + ",";
                }
                value = value.substring(0, value.length() - 1);
            } else {
                value = values[0];
            }
            String valueNew = SqlInjectionUtil.filter(value);
            url = url.replace(value, valueNew);
        }
        return url;
    }
}

