/*
 * Decompiled with CFR 0.152.
 */
package top.jpower.jpower.module.config;

import java.lang.reflect.Method;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.AnnotationUtils;
import top.jpower.jpower.module.annotation.Function;
import top.jpower.jpower.module.common.support.EnvBeanUtil;
import top.jpower.jpower.module.common.utils.Fc;
import top.jpower.jpower.module.common.utils.ShieldUtil;
import top.jpower.jpower.module.common.utils.WebUtil;

@Aspect
@Configuration
public class FunctionAuthAspect {
    private static final Logger log = LoggerFactory.getLogger(FunctionAuthAspect.class);

    @Pointcut(value="@annotation(top.jpower.jpower.module.annotation.Function)")
    public void authPointCut() {
    }

    @Before(value="authPointCut()")
    public void doBefore(JoinPoint joinPoint) {
        if (Fc.equalsValue((CharSequence)EnvBeanUtil.getProfile(), (CharSequence)"dev")) {
            return;
        }
        Function function = this.getAnnotation(joinPoint);
        if (Fc.isNull((Object)function)) {
            return;
        }
        HttpServletRequest request = WebUtil.getRequest();
        if (Fc.isNull((Object)request)) {
            return;
        }
        String menuCode = request.getHeader("Menu-Code");
        if (Fc.isBlank((CharSequence)menuCode)) {
            log.warn("\u8bf7\u6c42\u4e2d\u6ca1\u6709\u5e26{}\u5934\uff0c\u5224\u5b9a\u4e3a\u975e\u6cd5\u8bbf\u95ee\uff01\uff01\uff01", (Object)"Menu-Code");
            throw new GeneralSecurityException("\u975e\u6cd5\u8bbf\u95ee\uff01\uff01\uff01");
        }
        boolean is = Arrays.stream(function.menus()).filter(menu -> Fc.equalsValue((CharSequence)menu.client(), (CharSequence)ShieldUtil.getClientCodeFromHeader())).anyMatch(menu -> Fc.equalsValue((CharSequence)menuCode, (CharSequence)menu.menuCode()));
        if (!is) {
            log.warn("\u8bf7\u6c42\u5934{}\u503c\u4e0d\u5339\u914d\uff0c\u5224\u5b9a\u4e3a\u975e\u6cd5\u8bbf\u95ee\uff01\uff01\uff01", (Object)"Menu-Code");
            throw new GeneralSecurityException("\u975e\u6cd5\u8bbf\u95ee\uff01\uff01\uff01");
        }
    }

    private Function getAnnotation(JoinPoint joinPoint) {
        Signature signature = joinPoint.getSignature();
        MethodSignature methodSignature = (MethodSignature)signature;
        Method method = methodSignature.getMethod();
        if (Fc.notNull((Object)method)) {
            return (Function)AnnotationUtils.getAnnotation((Method)method, Function.class);
        }
        return null;
    }
}

