/*
 * Decompiled with CFR 0.152.
 */
package top.jpower.jpower.module.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import top.jpower.jpower.module.annotation.Function;
import top.jpower.jpower.module.annotation.Menu;
import top.jpower.jpower.module.common.utils.Fc;
import top.jpower.jpower.module.common.utils.MapUtil;

@Component
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class FunctionGenerate
implements ApplicationRunner {
    private RequestMappingHandlerMapping requestMappingHandlerMapping;
    public static final Map<String, List<Map<String, String>>> functions = new HashMap<String, List<Map<String, String>>>();

    public void run(ApplicationArguments args) {
        Map handlerMethodsMap = this.requestMappingHandlerMapping.getHandlerMethods();
        for (Map.Entry item : handlerMethodsMap.entrySet()) {
            RequestMappingInfo info = (RequestMappingInfo)item.getKey();
            HandlerMethod method = (HandlerMethod)item.getValue();
            PatternsRequestCondition p = info.getPatternsCondition();
            if (!Fc.notNull((Object)p) || !Fc.isNotEmpty((Object)p.getPatterns())) continue;
            String url = (String)p.getPatterns().stream().findFirst().get();
            Function function = (Function)method.getMethodAnnotation(Function.class);
            if (!Fc.notNull((Object)function)) continue;
            for (Menu menu : function.menus()) {
                if (!Fc.isNoneBlank((CharSequence[])new CharSequence[]{menu.menuCode(), menu.code()})) continue;
                List list = functions.getOrDefault(menu.menuCode(), new ArrayList());
                HashMap map = MapUtil.newHashMap((int)4);
                map.put("name", Fc.blankDefault((String)menu.name(), (String)function.value()));
                if (this.isExist(menu.code())) {
                    throw new IllegalArgumentException("@Function[code] [" + menu.code() + "] exist repeat value");
                }
                map.put("code", menu.code());
                map.put("btnCode", menu.btnCode());
                map.put("type", Fc.toStr((Object)menu.type().getValue()));
                map.put("alias", Fc.blankDefault((String)function.alias(), (String)((String)map.get("name"))));
                map.put("url", url);
                list.add(map);
                functions.put(menu.menuCode(), list);
            }
        }
    }

    private boolean isExist(String code) {
        boolean is = functions.containsKey(code);
        if (is) {
            return true;
        }
        for (String key : functions.keySet()) {
            is = functions.get(key).stream().anyMatch(m -> Fc.equalsValue((CharSequence)((CharSequence)m.get("code")), (CharSequence)code));
            if (!is) continue;
            return true;
        }
        return false;
    }

    public FunctionGenerate(RequestMappingHandlerMapping requestMappingHandlerMapping) {
        this.requestMappingHandlerMapping = requestMappingHandlerMapping;
    }
}

