package top.jpower.jpower.module.dbs.entity.base;

import cn.hutool.core.date.DatePattern;
import com.alibaba.fastjson2.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import top.jpower.jpower.module.common.validated.UpdateGroup;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * 基础Entity
 *
 * @author mr.g
 */
@Data
public class BaseEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    @TableId(value = "id",type = IdType.ASSIGN_ID)
    @NotNull(message = "ID 不可为空", groups = UpdateGroup.class)
    private Long id;

    @ApiModelProperty(value = "创建部门",hidden=true)
    @TableField(value = "create_org", fill = FieldFill.INSERT)
    private Long createOrg;

    @ApiModelProperty(value = "创建人",hidden=true)
    @TableField(value = "create_user", fill = FieldFill.INSERT)
    private Long createUser;

    @ApiModelProperty(value = "创建时间",hidden=true)
    @JSONField(format= DatePattern.NORM_DATETIME_PATTERN)
    @JsonFormat(shape = JsonFormat.Shape.STRING,timezone = "GMT+8", pattern = DatePattern.NORM_DATETIME_PATTERN,locale = "zh_CN")
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    private Date createTime;

    @ApiModelProperty(value = "修改人",hidden=true)
    @TableField(value = "update_user", fill = FieldFill.INSERT_UPDATE)
    private Long updateUser;

    @ApiModelProperty(value = "修改时间",hidden=true)
    @JsonFormat(shape = JsonFormat.Shape.STRING,timezone = "GMT+8", pattern = DatePattern.NORM_DATETIME_PATTERN,locale = "zh_CN")
    @JSONField(format= DatePattern.NORM_DATETIME_PATTERN)
    @TableField(value = "update_time", fill = FieldFill.INSERT_UPDATE)
    private Date updateTime;

    @ApiModelProperty(hidden = true)
    @TableField(fill = FieldFill.INSERT)
    @TableLogic
    @JsonIgnore
    @JSONField(serialize = false)
    private Boolean isDeleted;

    @ApiModelProperty(hidden = true)
    @TableField(exist = false)
    private Map<String, Object> params = new HashMap<>();

}
