/*
 * Decompiled with CFR 0.152.
 */
package top.jpower.jpower.module.config;

import com.baomidou.mybatisplus.core.config.GlobalConfig;
import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.baomidou.mybatisplus.core.injector.ISqlInjector;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.BlockAttackInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.DataPermissionInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.DynamicTableNameInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.IllegalSQLInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.OptimisticLockerInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.PaginationInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.TenantLineInnerInterceptor;
import java.util.stream.Collectors;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.core.annotation.Order;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import top.jpower.jpower.module.common.deploy.property.YamlAndPropertySourceFactory;
import top.jpower.jpower.module.config.UpdateRelatedFieldsMetaHandler;
import top.jpower.jpower.module.config.interceptor.DemoInterceptor;
import top.jpower.jpower.module.config.interceptor.JpowerMybatisInterceptor;
import top.jpower.jpower.module.config.interceptor.MybatisSqlPrintInterceptor;
import top.jpower.jpower.module.config.interceptor.chain.MybatisInterceptor;
import top.jpower.jpower.module.config.properties.DemoProperties;
import top.jpower.jpower.module.config.properties.MybatisProperties;
import top.jpower.jpower.module.mp.CustomSqlInjector;
import top.jpower.jpower.module.tenant.JpowerTenantProperties;

@EnableTransactionManagement
@MapperScan(value={"top.jpower.**.dbs.dao.**"})
@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={DemoProperties.class, MybatisProperties.class})
@PropertySource(value={"classpath:./jpower-db.yml"}, factory=YamlAndPropertySourceFactory.class)
public class MybatisPlusConfig {
    @Bean
    @ConditionalOnMissingBean
    public ISqlInjector sqlInjector(@Autowired(required=false) JpowerTenantProperties tenantProperties) {
        return new CustomSqlInjector(tenantProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    public UpdateRelatedFieldsMetaHandler updateRelatedFieldsMetaHandler() {
        return new UpdateRelatedFieldsMetaHandler();
    }

    @Bean
    @ConditionalOnMissingBean
    public GlobalConfig globalConfig(UpdateRelatedFieldsMetaHandler metaHandler, ISqlInjector sqlInjector) {
        GlobalConfig globalConfig = new GlobalConfig();
        globalConfig.setMetaObjectHandler((MetaObjectHandler)metaHandler);
        globalConfig.setSqlInjector(sqlInjector);
        return globalConfig;
    }

    @Bean
    @ConditionalOnMissingBean(value={MybatisPlusInterceptor.class})
    public MybatisPlusInterceptor mybatisPlusInterceptor(@Autowired(required=false) DataPermissionInterceptor dataPermissionInterceptor, @Autowired(required=false) TenantLineInnerInterceptor tenantLineInnerInterceptor, @Autowired(required=false) DynamicTableNameInnerInterceptor dynamicTableNameInnerInterceptor, ObjectProvider<InnerInterceptor> innerInterceptors, DemoProperties demoProperties, MybatisProperties mybatisProperties) {
        MybatisPlusInterceptor interceptor = new MybatisPlusInterceptor();
        if (tenantLineInnerInterceptor != null) {
            interceptor.addInnerInterceptor((InnerInterceptor)tenantLineInnerInterceptor);
        }
        if (dataPermissionInterceptor != null) {
            interceptor.addInnerInterceptor((InnerInterceptor)dataPermissionInterceptor);
        }
        if (dynamicTableNameInnerInterceptor != null) {
            interceptor.addInnerInterceptor((InnerInterceptor)dynamicTableNameInnerInterceptor);
        }
        if (mybatisProperties.isOptimisticLocker()) {
            interceptor.addInnerInterceptor((InnerInterceptor)new OptimisticLockerInnerInterceptor());
        }
        PaginationInnerInterceptor paginationInterceptor = new PaginationInnerInterceptor();
        paginationInterceptor.setOverflow(mybatisProperties.getPage().isOverflow());
        paginationInterceptor.setMaxLimit(mybatisProperties.getPage().getMaxLimit());
        paginationInterceptor.setOptimizeJoin(mybatisProperties.getPage().isOptimizeJoin());
        interceptor.addInnerInterceptor((InnerInterceptor)paginationInterceptor);
        if (mybatisProperties.isBlockAttack()) {
            interceptor.addInnerInterceptor((InnerInterceptor)new BlockAttackInnerInterceptor());
        }
        if (mybatisProperties.isIllegalSQL()) {
            interceptor.addInnerInterceptor((InnerInterceptor)new IllegalSQLInnerInterceptor());
        }
        if (demoProperties.isEnable()) {
            interceptor.addInnerInterceptor((InnerInterceptor)new DemoInterceptor(demoProperties));
        }
        innerInterceptors.orderedStream().collect(Collectors.toList()).forEach(innerInterceptor -> {
            if (!interceptor.getInterceptors().contains(innerInterceptor)) {
                interceptor.addInnerInterceptor(innerInterceptor);
            }
        });
        return interceptor;
    }

    @Bean
    @ConditionalOnMissingBean(value={JpowerMybatisInterceptor.class})
    public JpowerMybatisInterceptor jpowerMybatisInterceptor(ObjectProvider<MybatisInterceptor> mybatisInterceptors) {
        return new JpowerMybatisInterceptor(mybatisInterceptors.orderedStream().collect(Collectors.toList()));
    }

    @Order(value=-2147483648)
    @Bean
    @ConditionalOnProperty(value={"jpower.mybatis.sql.print"}, matchIfMissing=true)
    public MybatisSqlPrintInterceptor mybatisSqlPrintIntercepter(MybatisProperties mybatisProperties) {
        return new MybatisSqlPrintInterceptor(mybatisProperties.getSql());
    }
}

