/*
 * Decompiled with CFR 0.152.
 */
package top.jpower.jpower.module.config.interceptor;

import cn.hutool.core.annotation.AnnotationUtil;
import java.lang.reflect.AnnotatedElement;
import java.sql.Statement;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.ParameterMode;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.jpower.jpower.module.annotation.NoSqlLog;
import top.jpower.jpower.module.common.utils.DateUtil;
import top.jpower.jpower.module.common.utils.ExceptionUtil;
import top.jpower.jpower.module.common.utils.Fc;
import top.jpower.jpower.module.common.utils.ReflectUtil;
import top.jpower.jpower.module.common.utils.StringUtil;
import top.jpower.jpower.module.config.interceptor.chain.ChainFilter;
import top.jpower.jpower.module.config.interceptor.chain.MybatisInterceptor;
import top.jpower.jpower.module.config.properties.MybatisProperties;

public class MybatisSqlPrintInterceptor
implements MybatisInterceptor {
    private static final Logger log = LoggerFactory.getLogger(MybatisSqlPrintInterceptor.class);
    private final MybatisProperties.Sql sqlProperties;

    @Override
    public Object aroundUpdate(ChainFilter chainFilter, StatementHandler sh, MappedStatement ms, BoundSql boundSql, Statement statement) {
        return this.printSql(chainFilter, ms.getConfiguration(), ms.getId(), boundSql, true);
    }

    @Override
    public Object aroundQuery(ChainFilter chainFilter, StatementHandler sh, MappedStatement ms, BoundSql boundSql, Statement statement, ResultHandler resultHandler) {
        return this.printSql(chainFilter, ms.getConfiguration(), ms.getId(), boundSql, false);
    }

    public Object printSql(ChainFilter chainFilter, Configuration configuration, String mpId, BoundSql boundSql, boolean isUpdate) {
        if (this.isLog(mpId)) {
            long startTime = System.currentTimeMillis();
            Object rest = null;
            String error = null;
            try {
                rest = chainFilter.proceed();
            }
            catch (Exception e) {
                error = ExceptionUtil.getRootCauseMessage((Throwable)e);
                throw e;
            }
            finally {
                try {
                    long time = System.currentTimeMillis() - startTime;
                    if (time >= this.sqlProperties.getPrintTimeout()) {
                        this.printSql(boundSql, configuration, mpId, time, rest, isUpdate, error);
                    }
                }
                catch (Exception e) {
                    log.error("==> \u6253\u5370sql \u65e5\u5fd7\u5f02\u5e38 {}", (Object)("\n" + ExceptionUtil.getStackTraceAsString((Throwable)e)));
                }
            }
            return rest;
        }
        return chainFilter.proceed();
    }

    public void printSql(BoundSql boundSql, Configuration configuration, String sqlId, long time, Object rest, boolean isUpdate, String error) {
        String sql = this.formatSql(boundSql, configuration).concat(";");
        String[] mappers = MybatisSqlPrintInterceptor.getMapper(sqlId);
        StringBuilder sb = new StringBuilder("\n").append("\t").append("==> Mapper name\uff1a").append(mappers[0]).append("\n").append("\t").append("==> Mapper method\uff1a").append(mappers[1]).append("\n").append("\t").append("==> Execute SQL\uff1a").append(sql).append("\n").append("\t").append("<== Time\uff1a").append(time).append(" ms ").append("\n");
        if (isUpdate) {
            sb.append("\t").append("<== Updates: ").append(rest).append("\n");
        } else if (rest instanceof List) {
            List list = (List)rest;
            if (list.size() == 1) {
                sb.append("\t").append("<== Result: ").append(list.get(0)).append("\n");
            }
            sb.append("\t").append("<== Total: ").append(((List)rest).size()).append("\n");
        } else {
            sb.append("\t").append("<== Result: ").append(rest).append("\n");
        }
        if (Fc.isNotBlank((CharSequence)error)) {
            sb.append("\t").append("<== errorSqlInfo: ").append(error).append("\n");
        }
        log.info(sb.toString());
    }

    private boolean isLog(String mpId) {
        String[] mappers = MybatisSqlPrintInterceptor.getMapper(mpId);
        NoSqlLog noSqlLog = null;
        try {
            noSqlLog = (NoSqlLog)AnnotationUtil.getAnnotation((AnnotatedElement)ReflectUtil.getMethodByName(Class.forName(mappers[0]), (String)mappers[1]), NoSqlLog.class);
        }
        catch (ClassNotFoundException e) {
            return true;
        }
        return Fc.isNull((Object)noSqlLog);
    }

    private static String[] getMapper(String mapperId) {
        String methodName = StringUtil.subAfter((CharSequence)mapperId, (char)'.', (boolean)Boolean.TRUE);
        String className = StringUtil.subBefore((CharSequence)mapperId, (char)'.', (boolean)Boolean.TRUE);
        return new String[]{className, methodName};
    }

    private String formatSql(BoundSql boundSql, Configuration configuration) {
        String sql = boundSql.getSql();
        List parameterMappings = boundSql.getParameterMappings();
        Object parameterObject = boundSql.getParameterObject();
        if (Fc.isBlank((CharSequence)sql)) {
            return "";
        }
        if (configuration == null) {
            return "";
        }
        TypeHandlerRegistry typeHandlerRegistry = configuration.getTypeHandlerRegistry();
        sql = this.beautifySql(sql);
        if (parameterMappings != null) {
            for (ParameterMapping parameterMapping : parameterMappings) {
                Object value;
                if (parameterMapping.getMode() == ParameterMode.OUT) continue;
                String propertyName = parameterMapping.getProperty();
                if (boundSql.hasAdditionalParameter(propertyName)) {
                    value = boundSql.getAdditionalParameter(propertyName);
                } else if (parameterObject == null) {
                    value = null;
                } else if (typeHandlerRegistry.hasTypeHandler(parameterObject.getClass())) {
                    value = parameterObject;
                } else {
                    MetaObject metaObject = configuration.newMetaObject(parameterObject);
                    value = metaObject.getValue(propertyName);
                }
                String paramValueStr = "";
                paramValueStr = value instanceof String ? "'" + value + "'" : (value instanceof Date ? "'" + DateUtil.formatDateTime((Date)((Date)value)) + "'" : value + "");
                sql = sql.replaceFirst("\\?", Matcher.quoteReplacement(paramValueStr));
            }
        }
        return sql;
    }

    private String beautifySql(String sql) {
        sql = sql.replaceAll("[\\s\n ]+", " ");
        return sql;
    }

    public MybatisSqlPrintInterceptor(MybatisProperties.Sql sqlProperties) {
        this.sqlProperties = sqlProperties;
    }
}

