/*
 * Decompiled with CFR 0.152.
 */
package top.jpower.jpower.module.datascope;

import com.baomidou.mybatisplus.extension.plugins.handler.DataPermissionHandler;
import com.baomidou.mybatisplus.extension.plugins.inner.DataPermissionInterceptor;
import com.github.pagehelper.autoconfigure.PageHelperProperties;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import top.jpower.jpower.module.config.MybatisPlusConfig;
import top.jpower.jpower.module.datascope.JpowerPageHelper;
import top.jpower.jpower.module.datascope.handler.DataScopeHandler;

@Configuration(proxyBeanMethods=false)
@AutoConfigureBefore(value={MybatisPlusConfig.class})
public class DataScopeConfig {
    @Bean(value={"dataScopeHandler"})
    @ConditionalOnMissingBean(value={DataPermissionHandler.class})
    public DataPermissionHandler dataScopeHandler() {
        return new DataScopeHandler();
    }

    @Bean
    @ConditionalOnProperty(value={"jpower.datascope.enable"}, matchIfMissing=true)
    @ConditionalOnBean(value={DataPermissionHandler.class})
    @ConditionalOnMissingBean(value={DataPermissionInterceptor.class})
    public DataPermissionInterceptor dataScopeQueryInterceptor(PageHelperProperties properties, DataPermissionHandler dataPermissionHandler) {
        properties.setDialect(JpowerPageHelper.class.getName());
        properties.put((Object)"dataScopeHandler", (Object)dataPermissionHandler);
        return new DataPermissionInterceptor(dataPermissionHandler);
    }
}

