/*
 * Decompiled with CFR 0.152.
 */
package top.jpower.jpower.module.dbs.dao;

import cn.hutool.core.lang.tree.Tree;
import cn.hutool.core.util.ReflectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import top.jpower.jpower.module.common.node.ForestNodeMerger;
import top.jpower.jpower.module.common.utils.BeanUtil;
import top.jpower.jpower.module.common.utils.DateUtil;
import top.jpower.jpower.module.common.utils.Fc;
import top.jpower.jpower.module.common.utils.ShieldUtil;
import top.jpower.jpower.module.dbs.dao.mapper.base.JpowerBaseMapper;
import top.jpower.jpower.module.dbs.entity.base.BaseEntity;

public class JpowerServiceImpl<M extends JpowerBaseMapper<T>, T extends BaseEntity>
extends ServiceImpl<M, T> {
    private void resolveEntity(T entity, boolean isSave) {
        Long userId = ShieldUtil.getUserId();
        Long orgId = ShieldUtil.getOrgId();
        if (isSave) {
            ((BaseEntity)entity).setCreateTime((Date)DateUtil.date());
            if (Fc.isNull((Object)((BaseEntity)entity).getCreateUser()) && Fc.notNull((Object)userId)) {
                ((BaseEntity)entity).setCreateUser(userId);
            }
            if (Fc.isNull((Object)((BaseEntity)entity).getCreateOrg()) && Fc.notNull((Object)orgId)) {
                ((BaseEntity)entity).setCreateOrg(orgId);
            }
            ((BaseEntity)entity).setIsDeleted(Boolean.FALSE);
        }
        if (Fc.isNull((Object)((BaseEntity)entity).getUpdateUser()) && Fc.notNull((Object)userId)) {
            ((BaseEntity)entity).setUpdateUser(userId);
        }
        ((BaseEntity)entity).setUpdateTime((Date)DateUtil.date());
        Field field = ReflectUtil.getField(entity.getClass(), (String)"tenantCode");
        if (Fc.notNull((Object)field)) {
            String tenantCode = Fc.toStr((Object)top.jpower.jpower.module.common.utils.ReflectUtil.getFieldValue(entity, (String)"tenantCode"), (String)ShieldUtil.getTenantCode());
            if (ShieldUtil.isRoot() && isSave) {
                top.jpower.jpower.module.common.utils.ReflectUtil.setFieldValue(entity, (String)"tenantCode", (Object)Fc.toStr((Object)tenantCode, (String)"000000"));
            } else if (!ShieldUtil.isRoot()) {
                top.jpower.jpower.module.common.utils.ReflectUtil.setFieldValue(entity, (String)"tenantCode", (Object)tenantCode);
            }
        }
    }

    public boolean save(T entity) {
        this.resolveEntity(entity, true);
        return super.save(entity);
    }

    public boolean saveBatch(Collection<T> entityList, int batchSize) {
        entityList.forEach(e -> this.resolveEntity(e, true));
        return super.saveBatch(entityList, batchSize);
    }

    public boolean saveOrUpdate(T entity) {
        this.resolveEntity(entity, Fc.isNull((Object)((BaseEntity)entity).getId()));
        return super.saveOrUpdate(entity);
    }

    public boolean saveOrUpdateBatch(Collection<T> entityList, int batchSize) {
        entityList.forEach(e -> this.resolveEntity(e, Fc.isNull((Object)e.getId())));
        return super.saveOrUpdateBatch(entityList, batchSize);
    }

    public boolean updateBatchById(Collection<T> entityList) {
        entityList.forEach(e -> this.resolveEntity(e, false));
        return super.updateBatchById(entityList);
    }

    public boolean updateById(T entity) {
        this.resolveEntity(entity, false);
        return super.updateById(entity);
    }

    public boolean update(T entity, Wrapper<T> updateWrapper) {
        if (Fc.isNull(entity)) {
            entity = (BaseEntity)BeanUtil.newBean((Class)top.jpower.jpower.module.common.utils.ReflectUtil.getClassGenricType(((Object)((Object)this)).getClass(), (int)1));
        }
        this.resolveEntity(entity, false);
        return super.update(entity, updateWrapper);
    }

    public boolean removeRealById(Serializable id) {
        return SqlHelper.retBool((Integer)((JpowerBaseMapper)this.getBaseMapper()).deleteRealById(id));
    }

    public boolean removeReal(Wrapper<T> queryWrapper) {
        return SqlHelper.retBool((Integer)((JpowerBaseMapper)this.getBaseMapper()).deleteReal(queryWrapper));
    }

    public boolean removeRealByIds(Collection<? extends Serializable> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            return false;
        }
        return SqlHelper.retBool((Integer)((JpowerBaseMapper)this.getBaseMapper()).deleteRealBatchIds(idList));
    }

    public boolean removeRealByMap(Map<String, Object> columnMap) {
        Assert.notEmpty(columnMap, (String)"error: columnMap must not be empty", (Object[])new Object[0]);
        return SqlHelper.retBool((Integer)((JpowerBaseMapper)this.getBaseMapper()).deleteRealByMap(columnMap));
    }

    public boolean updateAllById(T entity) {
        this.resolveEntity(entity, false);
        return SqlHelper.retBool((Integer)((JpowerBaseMapper)this.getBaseMapper()).updateAllById(entity));
    }

    public boolean addBatchSomeColumn(List<T> entityList) {
        entityList.forEach(e -> this.resolveEntity(e, true));
        return SqlHelper.retBool((Integer)((JpowerBaseMapper)this.getBaseMapper()).insertBatchSomeColumn(entityList));
    }

    public <V> List<V> listConver(Wrapper<T> queryWrapper, Function<T, V> function) {
        return this.list(queryWrapper).stream().filter(Objects::nonNull).map(function).collect(Collectors.toList());
    }

    public <E extends Serializable> List<Tree<E>> tree(Wrapper<T> treeWrapper) {
        List list = this.listMaps(treeWrapper);
        return ForestNodeMerger.mergeTree(list);
    }
}

