/*
 * Decompiled with CFR 0.152.
 */
package top.jpower.jpower.module.dictbind.interceptor;

import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.ibatis.executor.resultset.ResultSetHandler;
import org.apache.ibatis.reflection.DefaultReflectorFactory;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.ReflectorFactory;
import org.apache.ibatis.reflection.factory.DefaultObjectFactory;
import org.apache.ibatis.reflection.factory.ObjectFactory;
import org.apache.ibatis.reflection.wrapper.DefaultObjectWrapperFactory;
import org.apache.ibatis.reflection.wrapper.ObjectWrapperFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.jpower.jpower.module.base.annotation.Dict;
import top.jpower.jpower.module.common.utils.BeanUtil;
import top.jpower.jpower.module.common.utils.ClassUtil;
import top.jpower.jpower.module.common.utils.Fc;
import top.jpower.jpower.module.common.utils.ReflectUtil;
import top.jpower.jpower.module.config.interceptor.chain.MybatisInterceptor;
import top.jpower.jpower.module.dictbind.handler.IDictBindHandler;

public class DictBindInterceptor
implements MybatisInterceptor {
    private static final Logger log = LoggerFactory.getLogger(DictBindInterceptor.class);
    private IDictBindHandler dictBindHandler;

    @Override
    public Object result(Object result, ResultSetHandler resultSetHandler, Statement statement) {
        Object object;
        List list;
        if (result instanceof List && (list = (List)result).size() > 0 && Fc.notNull(object = list.get(0)) && !ClassUtil.isSimpleValueType(object.getClass())) {
            ArrayList newList = new ArrayList(list.size());
            list.forEach(bean -> {
                MetaObject metaObject = MetaObject.forObject((Object)bean, (ObjectFactory)new DefaultObjectFactory(), (ObjectWrapperFactory)new DefaultObjectWrapperFactory(), (ReflectorFactory)new DefaultReflectorFactory());
                BeanUtil.getFiledByAnnotation(bean.getClass(), Dict.class).forEach(field -> {
                    Dict dict = field.getAnnotation(Dict.class);
                    if (Fc.isNotBlank((CharSequence)dict.name())) {
                        if (Fc.isNotBlank((CharSequence)dict.attributes()) && ReflectUtil.hasField(bean.getClass(), (String)dict.attributes())) {
                            this.dictBindHandler.setMetaObject(dict, field.getName(), metaObject.getValue(field.getName()), metaObject);
                        } else if (Fc.isBlank((CharSequence)dict.attributes())) {
                            this.dictBindHandler.setMetaObject(dict, field.getName(), metaObject.getValue(field.getName()), metaObject);
                        }
                    }
                });
                newList.add(metaObject.getOriginalObject());
            });
            return newList;
        }
        return result;
    }

    public IDictBindHandler getDictBindHandler() {
        return this.dictBindHandler;
    }

    public void setDictBindHandler(IDictBindHandler dictBindHandler) {
        this.dictBindHandler = dictBindHandler;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DictBindInterceptor)) {
            return false;
        }
        DictBindInterceptor other = (DictBindInterceptor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        IDictBindHandler this$dictBindHandler = this.getDictBindHandler();
        IDictBindHandler other$dictBindHandler = other.getDictBindHandler();
        return !(this$dictBindHandler == null ? other$dictBindHandler != null : !this$dictBindHandler.equals(other$dictBindHandler));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DictBindInterceptor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IDictBindHandler $dictBindHandler = this.getDictBindHandler();
        result = result * 59 + ($dictBindHandler == null ? 43 : $dictBindHandler.hashCode());
        return result;
    }

    public String toString() {
        return "DictBindInterceptor(dictBindHandler=" + this.getDictBindHandler() + ")";
    }

    public DictBindInterceptor() {
    }

    public DictBindInterceptor(IDictBindHandler dictBindHandler) {
        this.dictBindHandler = dictBindHandler;
    }
}

