/*
 * Decompiled with CFR 0.152.
 */
package top.jpower.jpower.module.mp.support;

import cn.hutool.core.util.ArrayUtil;
import com.baomidou.mybatisplus.core.conditions.AbstractWrapper;
import java.util.Map;
import top.jpower.jpower.module.common.utils.Fc;
import top.jpower.jpower.module.common.utils.SqlInjectionUtil;
import top.jpower.jpower.module.common.utils.StringUtil;
import top.jpower.jpower.module.mp.support.WrapperKeyword;

class SqlWrapper {
    private static final String[] SQL_REGEX = (String[])ArrayUtil.append((Object[])SqlInjectionUtil.SQL_CHAR, (Object[])new String[]{"--", "count", "group", "union", "alter", "grant", "execute", "exec", "xp_cmdshell", "call", "declare", "sql"});

    SqlWrapper() {
    }

    static void buildCondition(AbstractWrapper<?, String, ?> wrapper, Map<String, Object> query) {
        if (Fc.isEmpty(query)) {
            return;
        }
        query.forEach((k, v) -> {
            if (Fc.hasEmpty((Object[])new Object[]{k, v})) {
                return;
            }
            WrapperKeyword keyword = SqlWrapper.getKeyword(k);
            String column = SqlWrapper.filter(keyword.getColumn((String)k));
            if (Fc.isBlank((CharSequence)column)) {
                keyword = WrapperKeyword.IGNORE;
            }
            switch (keyword) {
                case EQ: 
                case DATE_EQ: {
                    wrapper.eq((Object)column, v);
                    break;
                }
                case NOT_EQ: {
                    wrapper.ne((Object)column, v);
                    break;
                }
                case LIKE: {
                    wrapper.like((Object)column, v);
                    break;
                }
                case LEFT_LIKE: {
                    wrapper.likeLeft((Object)column, v);
                    break;
                }
                case RIGHT_LIKE: {
                    wrapper.likeRight((Object)column, v);
                    break;
                }
                case NOT_LIKE: {
                    wrapper.notLike((Object)column, v);
                    break;
                }
                case GT: 
                case DATE_GT: {
                    wrapper.gt((Object)column, v);
                    break;
                }
                case LT: 
                case DATE_LT: {
                    wrapper.lt((Object)column, v);
                    break;
                }
                case GE: 
                case DATE_GE: {
                    wrapper.ge((Object)column, v);
                    break;
                }
                case LE: 
                case DATE_LE: {
                    wrapper.le((Object)column, v);
                    break;
                }
                case IS_NULL: {
                    wrapper.isNull((Object)column);
                    break;
                }
                case NOT_NULL: {
                    wrapper.isNotNull((Object)column);
                }
            }
        });
    }

    private static WrapperKeyword getKeyword(String column) {
        for (WrapperKeyword keyword : WrapperKeyword.values()) {
            if (!StringUtil.endWith((CharSequence)column, (CharSequence)keyword.getSuffixKeyword())) continue;
            return keyword;
        }
        return WrapperKeyword.LIKE;
    }

    private static String filter(String param) {
        if (Fc.isBlank((CharSequence)param)) {
            return null;
        }
        if (StringUtil.containsAny((CharSequence)(param = StringUtil.cleanBlank((CharSequence)param)), (CharSequence[])SQL_REGEX)) {
            param = "`" + param + "`";
        }
        return param;
    }
}

