/*
 * Decompiled with CFR 0.152.
 */
package top.jpower.jpower.module.tenant;

import com.baomidou.mybatisplus.extension.plugins.handler.TenantLineHandler;
import com.baomidou.mybatisplus.extension.plugins.inner.TenantLineInnerInterceptor;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import top.jpower.jpower.module.config.MybatisPlusConfig;
import top.jpower.jpower.module.tenant.InsertBatchSomeColumnTenant;
import top.jpower.jpower.module.tenant.JpowerTenantHandler;
import top.jpower.jpower.module.tenant.JpowerTenantProperties;

@Configuration(proxyBeanMethods=false)
@AutoConfigureBefore(value={MybatisPlusConfig.class})
@EnableConfigurationProperties(value={JpowerTenantProperties.class})
public class TenantConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={TenantLineHandler.class})
    public TenantLineHandler tenantHandler(JpowerTenantProperties properties) {
        return new JpowerTenantHandler(properties);
    }

    @Bean
    @ConditionalOnProperty(value={"jpower.tenant.enable"}, matchIfMissing=true)
    @ConditionalOnMissingBean(value={InsertBatchSomeColumnTenant.class})
    public InsertBatchSomeColumnTenant insertBatchSomeColumnTenant(TenantLineHandler tenantHandler) {
        return new InsertBatchSomeColumnTenant(tenantHandler);
    }

    @Bean
    @ConditionalOnProperty(value={"jpower.tenant.enable"}, matchIfMissing=true)
    @ConditionalOnMissingBean(value={TenantLineInnerInterceptor.class})
    public TenantLineInnerInterceptor tenantSqlParser(TenantLineHandler tenantHandler) {
        TenantLineInnerInterceptor innerInterceptor = new TenantLineInnerInterceptor();
        innerInterceptor.setTenantLineHandler(tenantHandler);
        return innerInterceptor;
    }
}

