/*
 * Decompiled with CFR 0.152.
 */
package top.jpower.jpower.module.common.node;

import cn.hutool.core.lang.tree.Tree;
import cn.hutool.core.lang.tree.TreeNodeConfig;
import cn.hutool.core.lang.tree.TreeUtil;
import cn.hutool.core.map.MapUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import top.jpower.jpower.module.common.utils.BeanUtil;
import top.jpower.jpower.module.common.utils.Fc;
import top.jpower.jpower.module.common.utils.StringUtil;

public class ForestNodeMerger {
    public static final TreeNodeConfig CONFIG = new TreeNodeConfig();
    public static final String HAS_CHILDREN = "hasChildren";

    public static <T> List<Tree<String>> mergeTree(List<T> list) {
        List<Tree<String>> listTree = TreeUtil.build(list, (Object)ForestNodeMerger.getRootId(list), (TreeNodeConfig)CONFIG, (bean, tree) -> {
            Map extra = bean instanceof Map ? (Map)bean : BeanUtil.beanToMap((Object)bean);
            if (extra.containsKey("sortNum")) {
                extra.put("sort", extra.get("sortNum"));
                extra.remove("sortNum");
            }
            if (MapUtil.isNotEmpty((Map)extra)) {
                extra.forEach((k, v) -> {
                    String key = StringUtil.underlineToHump((String)k);
                    if (Fc.equals((Object)key, (Object)HAS_CHILDREN)) {
                        v = Fc.toBool((Object)v, (Boolean)false);
                    }
                    tree.putExtra(key, v);
                });
            }
        });
        listTree = ForestNodeMerger.completionHasChildren(listTree);
        return listTree;
    }

    private static List<Tree<String>> completionHasChildren(List<Tree<String>> listTree) {
        if (Fc.isEmpty(listTree)) {
            return new ArrayList<Tree<String>>();
        }
        return listTree.stream().peek(map -> {
            if (Fc.isNotEmpty((Object)map.getChildren())) {
                ForestNodeMerger.completionHasChildren(map.getChildren());
                map.put((Object)HAS_CHILDREN, (Object)true);
            } else {
                map.put((Object)HAS_CHILDREN, (Object)Fc.toBool((Object)map.get((Object)HAS_CHILDREN), (Boolean)false));
            }
        }).collect(Collectors.toList());
    }

    private static <T> String getRootId(List<T> list) {
        AtomicReference<String> rootId = new AtomicReference<String>("-1");
        if (Fc.isNotEmpty(list)) {
            list.stream().forEach(t -> {
                Map<String, Object> map = ForestNodeMerger.beanToMap(t);
                long count = list.stream().filter(i -> {
                    Map<String, Object> map1 = ForestNodeMerger.beanToMap(i);
                    return Fc.equals((Object)map1.get(CONFIG.getIdKey()), map.get(CONFIG.getParentIdKey()));
                }).count();
                if (count <= 0L) {
                    rootId.set(Fc.toStr((Object)map.get(CONFIG.getParentIdKey()), (String)"-1"));
                    return;
                }
            });
        }
        return rootId.get();
    }

    private static <T> Map<String, Object> beanToMap(T t) {
        Map map = BeanUtil.beanToMap(t);
        if (!map.containsKey(CONFIG.getIdKey())) {
            MapUtil.renameKey((Map)map, (Object)StringUtil.humpToUnderline((String)CONFIG.getIdKey()), (Object)CONFIG.getIdKey());
        }
        if (!map.containsKey(CONFIG.getParentIdKey())) {
            MapUtil.renameKey((Map)map, (Object)StringUtil.humpToUnderline((String)CONFIG.getParentIdKey()), (Object)CONFIG.getParentIdKey());
        }
        return map;
    }

    static {
        CONFIG.setWeightKey("sort");
    }
}

