/*
 * Decompiled with CFR 0.152.
 */
package top.jpower.jpower.module.config.interceptor;

import java.sql.Statement;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ibatis.executor.resultset.ResultSetHandler;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import top.jpower.jpower.module.common.utils.ClassUtil;
import top.jpower.jpower.module.common.utils.Fc;
import top.jpower.jpower.module.config.interceptor.chain.ChainFilter;
import top.jpower.jpower.module.config.interceptor.chain.MybatisInterceptor;

@Intercepts(value={@Signature(type=StatementHandler.class, method="update", args={Statement.class}), @Signature(type=StatementHandler.class, method="batch", args={Statement.class}), @Signature(type=StatementHandler.class, method="query", args={Statement.class, ResultHandler.class}), @Signature(type=ResultSetHandler.class, method="handleResultSets", args={Statement.class})})
public class JpowerMybatisInterceptor
implements Interceptor {
    List<MybatisInterceptor> interceptors;

    public Object intercept(Invocation invocation) {
        Object target = invocation.getTarget();
        if (target instanceof StatementHandler) {
            return new ChainFilter(this.interceptors.iterator(), invocation).proceed();
        }
        if (target instanceof ResultSetHandler) {
            List list;
            Object rest = invocation.proceed();
            if (!(!(rest instanceof List) || (list = (List)rest).size() == 1 && Fc.notNull(list.get(0)) && ClassUtil.isSimpleValueType((Class)ClassUtil.getClass(list.get(0))))) {
                Statement statement = (Statement)invocation.getArgs()[0];
                ResultSetHandler resultSetHandler = (ResultSetHandler)target;
                AtomicReference<Object> atomicReference = new AtomicReference<Object>(rest);
                this.interceptors.forEach(interceptor -> atomicReference.set(interceptor.result(atomicReference.get(), resultSetHandler, statement)));
                return atomicReference.get();
            }
            return rest;
        }
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        if (target instanceof StatementHandler || target instanceof ResultSetHandler) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public JpowerMybatisInterceptor(List<MybatisInterceptor> interceptors) {
        this.interceptors = interceptors;
    }
}

