/*
 * Decompiled with CFR 0.152.
 */
package top.jpower.jpower.module.config.interceptor.chain;

import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import java.sql.Statement;
import java.util.Iterator;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.session.ResultHandler;
import top.jpower.jpower.module.config.interceptor.chain.MybatisInterceptor;

public class ChainFilter {
    private final Iterator<MybatisInterceptor> interceptors;
    private final Invocation invocation;
    private final MappedStatement ms;
    private final boolean isUpdate;
    private final BoundSql boundSql;
    private final StatementHandler sh;
    private final Statement statement;
    private ResultHandler resultHandler;

    public ChainFilter(Iterator<MybatisInterceptor> interceptors, Invocation invocation) {
        this.interceptors = interceptors;
        this.invocation = invocation;
        this.sh = (StatementHandler)invocation.getTarget();
        Object[] args = invocation.getArgs();
        this.boundSql = this.sh.getBoundSql();
        PluginUtils.MPStatementHandler mpSh = PluginUtils.mpStatementHandler((StatementHandler)this.sh);
        this.ms = mpSh.mappedStatement();
        SqlCommandType sct = this.ms.getSqlCommandType();
        this.isUpdate = sct == SqlCommandType.INSERT || sct == SqlCommandType.UPDATE || sct == SqlCommandType.DELETE;
        this.statement = (Statement)args[0];
        if (this.ms.getSqlCommandType() == SqlCommandType.SELECT) {
            this.resultHandler = (ResultHandler)args[1];
        }
    }

    public Object proceed() {
        if (this.interceptors.hasNext()) {
            if (this.isUpdate) {
                return this.interceptors.next().aroundUpdate(this, this.sh, this.ms, this.boundSql, this.statement);
            }
            if (this.ms.getSqlCommandType() == SqlCommandType.SELECT) {
                return this.interceptors.next().aroundQuery(this, this.sh, this.ms, this.boundSql, this.statement, this.resultHandler);
            }
        }
        return this.invocation.proceed();
    }
}

