/*
 * Decompiled with CFR 0.152.
 */
package top.jpower.jpower.module.datascope.handler;

import cn.hutool.core.annotation.AnnotationUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.toolkit.LambdaUtils;
import com.baomidou.mybatisplus.extension.plugins.handler.DataPermissionHandler;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.ItemsList;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import org.apache.ibatis.reflection.property.PropertyNamer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import top.jpower.jpower.module.common.auth.UserInfo;
import top.jpower.jpower.module.common.support.ChainMap;
import top.jpower.jpower.module.common.utils.BeanUtil;
import top.jpower.jpower.module.common.utils.CollectionUtil;
import top.jpower.jpower.module.common.utils.DateUtil;
import top.jpower.jpower.module.common.utils.Fc;
import top.jpower.jpower.module.common.utils.ReflectUtil;
import top.jpower.jpower.module.common.utils.ShieldUtil;
import top.jpower.jpower.module.common.utils.StringUtil;
import top.jpower.jpower.module.common.utils.WebUtil;
import top.jpower.jpower.module.common.utils.constants.ConstantsEnum;
import top.jpower.jpower.module.datascope.DataScope;
import top.jpower.jpower.module.dbs.config.LoginUserContext;

public class DataScopeHandler
implements DataPermissionHandler {
    private static final Logger log = LoggerFactory.getLogger(DataScopeHandler.class);

    public Expression getSqlSegment(Expression where, String mapperId) {
        DataScope dataScope = this.findDataScope(mapperId);
        if (Fc.isNull((Object)dataScope) || ShieldUtil.isRoot()) {
            return where;
        }
        if (Fc.equalsValue((CharSequence)mapperId, (CharSequence)dataScope.getScopeClass())) {
            EqualsTo andWhere;
            if (Fc.isNull((Object)LoginUserContext.get())) {
                log.warn("\u672a\u83b7\u53d6\u5230\u7528\u6237\uff0c\u65e0\u6cd5\u8fdb\u884c\u6570\u636e\u6743\u9650\u8fc7\u6ee4");
                return CCJSqlParserUtil.parseCondExpression((String)"1 = 2");
            }
            if (Fc.equals((Object)dataScope.getScopeType(), (Object)ConstantsEnum.DATA_SCOPE_TYPE.ALL.getValue())) {
                return where;
            }
            if (Fc.equals((Object)dataScope.getScopeType(), (Object)ConstantsEnum.DATA_SCOPE_TYPE.CUSTOM.getValue())) {
                Map userMap = ChainMap.create().build();
                BeanUtil.beanToMap((Object)LoginUserContext.get(), (Map)userMap, (CopyOptions)new CopyOptions(){

                    protected Object editFieldValue(String fieldName, Object fieldValue) {
                        switch (fieldName) {
                            case "birthday": 
                            case "lastLoginTime": {
                                fieldValue = Fc.isNull((Object)fieldValue) ? DateUtil.now() : fieldValue;
                                break;
                            }
                            case "idType": 
                            case "loginCount": 
                            case "userType": {
                                fieldValue = Fc.isNull((Object)fieldValue) ? Integer.valueOf(-999) : fieldValue;
                                break;
                            }
                            case "roleIds": 
                            case "childOrgId": {
                                fieldValue = Fc.isNull((Object)fieldValue) ? new ArrayList() : fieldValue;
                                break;
                            }
                            default: {
                                fieldValue = Fc.isNull((Object)fieldValue) ? "" : fieldValue;
                            }
                        }
                        return fieldValue;
                    }
                });
                userMap.put(PropertyNamer.methodToProperty((String)LambdaUtils.extract(UserInfo::getRoleIds).getImplMethodName()), StringUtils.collectionToDelimitedString((Collection)LoginUserContext.get().getRoleIds(), (String)",", (String)"'", (String)"'"));
                HashSet listOrgId = CollectionUtil.newHashSet((Collection)LoginUserContext.get().getChildOrgId());
                listOrgId.add(LoginUserContext.getOrgId());
                userMap.put(PropertyNamer.methodToProperty((String)LambdaUtils.extract(UserInfo::getChildOrgId).getImplMethodName()), StringUtils.collectionToDelimitedString((Collection)listOrgId, (String)",", (String)"'", (String)"'"));
                andWhere = CCJSqlParserUtil.parseCondExpression((String)StringUtil.formatMap((CharSequence)Fc.toStr((Object)dataScope.getScopeValue(), (String)"1=1"), (Map)userMap));
            } else if (Fc.equals((Object)dataScope.getScopeType(), (Object)ConstantsEnum.DATA_SCOPE_TYPE.OWN.getValue())) {
                andWhere = new EqualsTo().withLeftExpression((Expression)new Column(dataScope.getScopeColumn())).withRightExpression((Expression)new StringValue(LoginUserContext.getUserId()));
            } else if (Fc.equals((Object)dataScope.getScopeType(), (Object)ConstantsEnum.DATA_SCOPE_TYPE.OWN_ORG.getValue())) {
                andWhere = new EqualsTo().withLeftExpression((Expression)new Column(dataScope.getScopeColumn())).withRightExpression((Expression)new StringValue(LoginUserContext.getOrgId()));
            } else if (Fc.equals((Object)dataScope.getScopeType(), (Object)ConstantsEnum.DATA_SCOPE_TYPE.OWN_ORG_CHILD.getValue())) {
                HashSet listOrgId = CollectionUtil.newHashSet((Collection)LoginUserContext.get().getChildOrgId());
                listOrgId.add(LoginUserContext.getOrgId());
                listOrgId.add("-1");
                ExpressionList itemsList = new ExpressionList(listOrgId.stream().filter(Fc::isNotBlank).map(StringValue::new).collect(Collectors.toList()));
                andWhere = new InExpression((Expression)new Column(dataScope.getScopeColumn()), (ItemsList)itemsList);
            } else {
                return where;
            }
            andWhere = CCJSqlParserUtil.parseCondExpression((String)("(" + andWhere.toString() + ")"));
            log.debug("DATASCOPE WHERE : {}", (Object)andWhere.toString());
            return where == null ? andWhere : new AndExpression(where, (Expression)andWhere);
        }
        return where;
    }

    private DataScope findDataScope(String mapperId) {
        List dataScopeList;
        DataScope dataScope;
        if (Fc.isNull((Object)WebUtil.getRequest())) {
            return null;
        }
        String data = WebUtil.getRequest().getHeader("data-scope");
        if (Fc.isNotBlank((CharSequence)data) && Fc.notNull((Object)(dataScope = (DataScope)(dataScopeList = JSON.parseArray((String)data, DataScope.class)).stream().filter(d -> Fc.equalsValue((CharSequence)d.getScopeClass(), (CharSequence)mapperId)).findFirst().orElse(null))) && Fc.isNotBlank((CharSequence)dataScope.getScopeClass())) {
            return dataScope;
        }
        try {
            String methodName = StringUtil.subAfter((CharSequence)mapperId, (char)'.', (boolean)Boolean.TRUE);
            String className = StringUtil.subBefore((CharSequence)mapperId, (char)'.', (boolean)Boolean.TRUE);
            top.jpower.jpower.module.datascope.annotation.DataScope dataScopeAnnotation = (top.jpower.jpower.module.datascope.annotation.DataScope)AnnotationUtil.getAnnotation((AnnotatedElement)ReflectUtil.getMethodByName(Class.forName(className), (String)methodName), top.jpower.jpower.module.datascope.annotation.DataScope.class);
            if (Fc.notNull((Object)dataScopeAnnotation)) {
                DataScope dataScope2 = new DataScope();
                dataScope2.setScopeType(dataScopeAnnotation.type().getValue());
                dataScope2.setScopeColumn(dataScopeAnnotation.column());
                dataScope2.setScopeClass(mapperId);
                dataScope2.setScopeValue(dataScopeAnnotation.sql());
                return dataScope2;
            }
        }
        catch (ClassNotFoundException e) {
            log.warn("\u6570\u636e\u6743\u9650\u672a\u627e\u5230\u7c7b={}", (Object)mapperId);
        }
        return null;
    }
}

