/*
 * Decompiled with CFR 0.152.
 */
package top.jpower.jpower.module.tenant;

import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.extension.plugins.handler.TenantLineHandler;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import net.sf.jsqlparser.expression.StringValue;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.jpower.jpower.module.common.utils.ExceptionUtil;
import top.jpower.jpower.module.common.utils.Fc;

public class InsertBatchSomeColumnTenant
implements InnerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(InsertBatchSomeColumnTenant.class);
    private TenantLineHandler tenantLineHandler;

    public void beforeUpdate(Executor executor, MappedStatement ms, Object parameter) {
        Map map;
        Object object;
        if (SqlCommandType.INSERT != ms.getSqlCommandType()) {
            return;
        }
        String methodName = ms.getId().substring(ms.getId().lastIndexOf(".") + 1);
        if ("insertBatchSomeColumn".equals(methodName) && parameter instanceof Map && (object = (map = (Map)parameter).getOrDefault("list", null)) instanceof List && Fc.isNotEmpty(object)) {
            this.doTenantValue(object);
        }
    }

    protected void doTenantValue(List list) {
        TableInfo tableInfo = TableInfoHelper.getTableInfo(list.get(0).getClass());
        if (tableInfo == null) {
            return;
        }
        if (this.tenantLineHandler.ignoreTable(tableInfo.getTableName())) {
            return;
        }
        Field field = tableInfo.getFieldList().stream().filter(fieldInfo -> Fc.equalsValue((CharSequence)fieldInfo.getColumn(), (CharSequence)this.tenantLineHandler.getTenantIdColumn())).findFirst().map(TableFieldInfo::getField).orElse(null);
        if (Fc.notNull((Object)field)) {
            list.forEach(ob -> {
                try {
                    Object val = field.get(ob);
                    if (Fc.isNull((Object)val)) {
                        field.set(ob, ((StringValue)this.tenantLineHandler.getTenantId()).getValue());
                    }
                }
                catch (IllegalAccessException e) {
                    log.error("insertBatchSomeColumn tenant value set error:{}", (Object)ExceptionUtil.getStackTraceAsString((Throwable)e));
                }
            });
        }
    }

    public InsertBatchSomeColumnTenant(TenantLineHandler tenantLineHandler) {
        this.tenantLineHandler = tenantLineHandler;
    }
}

