/*
 * Decompiled with CFR 0.152.
 */
package top.jpower.jpower.module.tenant;

import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.extension.plugins.handler.TenantLineHandler;
import java.util.ArrayList;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.StringValue;
import org.springframework.beans.factory.SmartInitializingSingleton;
import top.jpower.jpower.module.common.utils.Fc;
import top.jpower.jpower.module.common.utils.ShieldUtil;
import top.jpower.jpower.module.common.utils.WebUtil;
import top.jpower.jpower.module.tenant.JpowerTenantProperties;

public class JpowerTenantHandler
implements TenantLineHandler,
SmartInitializingSingleton {
    private final JpowerTenantProperties properties;
    private final List<String> tenantTableList = new ArrayList<String>();
    private final String TENANT_TABLE = "tb_core_tenant";

    public Expression getTenantId() {
        return new StringValue(Fc.isBlank((CharSequence)ShieldUtil.getTenantCode()) ? "000000" : ShieldUtil.getTenantCode());
    }

    public String getTenantIdColumn() {
        return this.properties.getColumn();
    }

    public boolean ignoreTable(String tableName) {
        return !this.tenantTableList.contains(tableName) || Fc.isNull((Object)WebUtil.getRequest()) || ShieldUtil.isRoot() || Fc.isBlank((CharSequence)ShieldUtil.getTenantCode());
    }

    public void afterSingletonsInstantiated() {
        this.properties.getExcludeTables().add("tb_core_tenant");
        List tableInfos = TableInfoHelper.getTableInfos();
        tableInfos.forEach(tableInfo -> {
            if (!this.properties.getExcludeTables().contains(tableInfo.getTableName())) {
                tableInfo.getFieldList().stream().filter(tableFieldInfo -> Fc.equals((Object)tableFieldInfo.getColumn(), (Object)this.properties.getColumn())).forEach(tableFieldInfo -> this.tenantTableList.add(tableInfo.getTableName()));
            }
        });
    }

    public JpowerTenantHandler(JpowerTenantProperties properties) {
        this.properties = properties;
    }
}

