/*
 * Decompiled with CFR 0.152.
 */
package top.jpower.jpower.config;

import com.alibaba.fastjson.support.spring.FastJsonHttpMessageConverter;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.List;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.web.client.RestTemplate;
import top.jpower.jpower.module.common.utils.WebUtil;

@Configuration(proxyBeanMethods=false)
public class RestTemplateConfig {
    private static final Logger log = LoggerFactory.getLogger(RestTemplateConfig.class);

    @Bean
    @LoadBalanced
    @ConditionalOnMissingBean(value={RestTemplate.class})
    public RestTemplate restTemplate() {
        HttpComponentsClientHttpRequestFactory httpRequestFactory = new HttpComponentsClientHttpRequestFactory();
        httpRequestFactory.setHttpClient((HttpClient)this.httpClientBuilder().build());
        httpRequestFactory.setConnectionRequestTimeout(3000);
        httpRequestFactory.setConnectTimeout(3000);
        httpRequestFactory.setReadTimeout(120000);
        RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)httpRequestFactory);
        restTemplate.getInterceptors().add((request, body, execution) -> {
            Enumeration headerNames = WebUtil.getRequest().getHeaderNames();
            if (headerNames != null) {
                while (headerNames.hasMoreElements()) {
                    String name = (String)headerNames.nextElement();
                    if (!name.equalsIgnoreCase("Authorization") && !name.equalsIgnoreCase("User-Type") && !name.equalsIgnoreCase("Menu-Code") && !name.equalsIgnoreCase("jpower-auth") && !name.equalsIgnoreCase("Tenant-Code") && !name.equalsIgnoreCase("data-scope") && !name.equalsIgnoreCase("jpower-auth-pass")) continue;
                    String values = WebUtil.getRequest().getHeader(name);
                    request.getHeaders().add(name, values);
                }
            }
            return execution.execute(request, body);
        });
        List converterList = restTemplate.getMessageConverters();
        HttpMessageConverter converterTarget = null;
        for (HttpMessageConverter item : converterList) {
            if (StringHttpMessageConverter.class != item.getClass()) continue;
            converterTarget = item;
            break;
        }
        if (null != converterTarget) {
            converterList.remove(converterTarget);
        }
        converterList.add(1, new StringHttpMessageConverter(StandardCharsets.UTF_8));
        converterList.add(new FastJsonHttpMessageConverter());
        return restTemplate;
    }

    public HttpClientBuilder httpClientBuilder() {
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        httpClientBuilder.setConnectionManager(this.poolingConnectionManager());
        return httpClientBuilder;
    }

    public HttpClientConnectionManager poolingConnectionManager() {
        PoolingHttpClientConnectionManager poolingConnectionManager = new PoolingHttpClientConnectionManager();
        poolingConnectionManager.setMaxTotal(1000);
        poolingConnectionManager.setDefaultMaxPerRoute(500);
        return poolingConnectionManager;
    }
}

