/*
 * Decompiled with CFR 0.152.
 */
package top.jpower.jpower.feign.config;

import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import okhttp3.ConnectionPool;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.commons.httpclient.HttpClientConfiguration;
import org.springframework.cloud.commons.httpclient.OkHttpClientConnectionPoolFactory;
import org.springframework.cloud.commons.httpclient.OkHttpClientFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import top.jpower.jpower.feign.interceptor.HttpLogInterceptor;
import top.jpower.jpower.feign.properties.FeignHttpProperties;

@Configuration(proxyBeanMethods=false)
@ConditionalOnMissingBean(value={OkHttpClient.class})
@ComponentScan(basePackageClasses={HttpClientConfiguration.class})
@EnableConfigurationProperties(value={FeignHttpProperties.class})
@DependsOn(value={"envBeanUtil"})
public class FeignOkHttpConfiguration {
    private OkHttpClient okHttpClient;

    @Bean
    public HttpLogInterceptor httpLogInterceptor(FeignHttpProperties httpProperties) {
        return new HttpLogInterceptor(httpProperties.getLogLevel());
    }

    @Bean
    @ConditionalOnMissingBean(value={ConnectionPool.class})
    public ConnectionPool httpClientConnectionPool(FeignHttpProperties httpProperties, OkHttpClientConnectionPoolFactory connectionPoolFactory) {
        return connectionPoolFactory.create(httpProperties.getMaxConnections(), httpProperties.getTimeToLive(), httpProperties.getTimeToLiveUnit());
    }

    @Bean
    public OkHttpClient client(OkHttpClientFactory httpClientFactory, ConnectionPool connectionPool, FeignHttpProperties httpProperties, HttpLogInterceptor logInterceptor) {
        this.okHttpClient = httpClientFactory.createBuilder(httpProperties.isDisableSslValidation()).connectTimeout((long)httpProperties.getConnectionTimeout(), TimeUnit.MILLISECONDS).followRedirects(httpProperties.isFollowRedirects()).connectionPool(connectionPool).retryOnConnectionFailure(httpProperties.isRetryOnConnectionFailure()).callTimeout((long)httpProperties.getCallTimeout(), TimeUnit.MILLISECONDS).readTimeout((long)httpProperties.getReadTimeout(), TimeUnit.MILLISECONDS).writeTimeout((long)httpProperties.getWriteTimeout(), TimeUnit.MILLISECONDS).addNetworkInterceptor((Interceptor)logInterceptor).build();
        return this.okHttpClient;
    }

    @PreDestroy
    public void destroy() {
        if (this.okHttpClient != null) {
            this.okHttpClient.dispatcher().executorService().shutdown();
            this.okHttpClient.connectionPool().evictAll();
        }
    }
}

