/*
 * Decompiled with CFR 0.152.
 */
package top.jpower.jpower.feign.interceptor;

import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Configuration
public class HeaderRequestInterceptor
implements RequestInterceptor {
    private static final Logger log = LoggerFactory.getLogger(HeaderRequestInterceptor.class);

    public void apply(RequestTemplate requestTemplate) {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (attributes != null) {
            HttpServletRequest request = attributes.getRequest();
            Enumeration headerNames = request.getHeaderNames();
            if (headerNames != null) {
                while (headerNames.hasMoreElements()) {
                    String name = (String)headerNames.nextElement();
                    if (!name.equalsIgnoreCase("Authorization") && !name.equalsIgnoreCase("User-Type") && !name.equalsIgnoreCase("Menu-Code") && !name.equalsIgnoreCase("jpower-auth") && !name.equalsIgnoreCase("Tenant-Code") && !name.equalsIgnoreCase("data-scope") && !name.equalsIgnoreCase("jpower-auth-pass")) continue;
                    String values = request.getHeader(name);
                    requestTemplate.header(name, new String[]{values});
                }
            }
            if (!requestTemplate.queries().containsKey("tenantCode")) {
                requestTemplate.query("tenantCode", new String[]{request.getParameter("tenantCode")});
            }
        }
    }
}

