/*
 * Decompiled with CFR 0.152.
 */
package top.jpower.jpower.feign.interceptor;

import feign.Logger;
import java.io.IOException;
import java.net.SocketException;
import java.nio.charset.Charset;
import okhttp3.Connection;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.http.HttpHeaders;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;
import top.jpower.jpower.module.common.utils.BufferUtil;
import top.jpower.jpower.module.common.utils.ExceptionUtil;
import top.jpower.jpower.module.common.utils.Fc;
import top.jpower.jpower.module.common.utils.constants.CharsetKit;

public class HttpLogInterceptor
implements Interceptor,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(HttpLogInterceptor.class);
    private final Logger.Level level;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Response intercept(Interceptor.Chain chain) {
        Request request = chain.request();
        Connection connection = chain.connection();
        Response response = null;
        long time = 0L;
        try {
            long startTime = System.currentTimeMillis();
            response = chain.proceed(request);
            time = System.currentTimeMillis() - startTime;
            Response response2 = response;
            return response2;
        }
        catch (SocketException e) {
            log.warn("\u3010feign\u3011{} {} request fail:{}", new Object[]{request.method(), request.url(), e.getMessage()});
            throw e;
        }
        catch (Exception e) {
            log.error("\u3010feign\u3011{} {} request fail:{}", new Object[]{request.method(), request.url(), "\n" + ExceptionUtil.getStackTraceAsString((Throwable)e)});
            throw e;
        }
        finally {
            if (this.level != Logger.Level.NONE && Fc.notNull((Object)response)) {
                try {
                    this.printLog(request, response, connection, time);
                }
                catch (Exception e) {
                    log.error("\u3010feign\u3011 Error printing request log:{}", (Object)("\n" + ExceptionUtil.getStackTraceAsString((Throwable)e)));
                }
            }
        }
    }

    private void printLog(Request request, Response response, Connection connection, long time) throws IOException {
        StringBuilder builder = new StringBuilder("\n============start feign http=============").append("\n");
        builder.append("-->").append(request.method()).append(" ").append(request.url()).append(" ").append(Fc.notNull((Object)connection) ? connection.protocol() : "").append("\n");
        if (this.level == Logger.Level.HEADERS || this.level == Logger.Level.FULL) {
            builder.append("request headers: ").append("\n");
            Headers requestHeaders = request.headers();
            int count = requestHeaders.size();
            for (int i = 0; i < count; ++i) {
                builder.append("\t").append(requestHeaders.name(i)).append(" ").append("=").append(" ").append(requestHeaders.value(i)).append("\n");
            }
        }
        String rqBody = "";
        if (this.level == Logger.Level.FULL) {
            RequestBody requestBody = request.body();
            if (Fc.notNull((Object)requestBody)) {
                builder.append("request body: ").append(requestBody.contentLength() != -1L ? requestBody.contentLength() + "-byte" : "unknown-length").append(" ").append(requestBody.contentType()).append("\n");
                rqBody = this.readRequestBody(requestBody);
                builder.append("\t").append(rqBody).append("\n");
            } else {
                builder.append("request body is null").append("\n");
            }
        }
        builder.append("--> end request").append("(").append(rqBody.getBytes().length).append("-byte body").append(")").append("\n");
        builder.append("\n");
        builder.append("<--").append(response.protocol()).append(" ").append(response.code()).append(" ").append(response.message()).append(" ").append("(").append(time).append("ms").append(")").append(" ").append("\n");
        if (this.level == Logger.Level.HEADERS || this.level == Logger.Level.FULL) {
            builder.append("response headers: ").append("\n");
            Headers responseHeaders = response.headers();
            int count = responseHeaders.size();
            for (int i = 0; i < count; ++i) {
                builder.append("\t").append(responseHeaders.name(i)).append(" ").append("=").append(" ").append(responseHeaders.value(i)).append("\n");
            }
        }
        String rpBody = "";
        if (this.level == Logger.Level.FULL) {
            if (HttpHeaders.hasBody((Response)response)) {
                ResponseBody responseBody = response.body();
                builder.append("response body: ").append(responseBody.contentLength() != -1L ? responseBody.contentLength() + "-byte" : "unknown-length").append(" ").append(responseBody.contentType()).append("\n");
                rpBody = this.readResponseBody(responseBody);
                builder.append("\t").append(rpBody).append("\n");
            } else {
                builder.append("response body is null").append("\n");
            }
        }
        builder.append("<-- end response").append("(").append(rpBody.getBytes().length).append("-byte body").append(")").append("\n");
        builder.append("============end feign http=============");
        log.info(builder.toString());
    }

    private String readResponseBody(ResponseBody responseBody) {
        if (Fc.notNull((Object)responseBody)) {
            try {
                BufferedSource source = responseBody.source();
                source.request(Long.MAX_VALUE);
                Buffer buffer = source.getBuffer();
                Charset charset = CharsetKit.CHARSET_UTF_8;
                if (responseBody.contentType() != null) {
                    charset = responseBody.contentType().charset(CharsetKit.CHARSET_UTF_8);
                }
                return BufferUtil.cloneRead((Buffer)buffer, (Charset)charset);
            }
            catch (IOException e) {
                return "(unknown bodyContent)";
            }
        }
        return "responseBody is null";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readRequestBody(RequestBody requestBody) {
        try (Buffer buffer = new Buffer();){
            if (Fc.notNull((Object)requestBody)) {
                requestBody.writeTo((BufferedSink)buffer);
                Charset charset = CharsetKit.CHARSET_UTF_8;
                if (requestBody.contentType() != null) {
                    charset = requestBody.contentType().charset(CharsetKit.CHARSET_UTF_8);
                }
                String string2 = BufferUtil.read((Buffer)buffer, (Charset)charset);
                return string2;
            }
            String string = "requestBody is null";
            return string;
        }
        catch (IOException e) {
            return "(unknown bodyContent)";
        }
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public HttpLogInterceptor(Logger.Level level) {
        this.level = level;
    }
}

