/*
 * Decompiled with CFR 0.152.
 */
package top.jpower.jpower.feign.properties;

import feign.Logger;
import java.util.concurrent.TimeUnit;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.openfeign.support.FeignHttpClientProperties;
import top.jpower.jpower.module.common.support.EnvBeanUtil;
import top.jpower.jpower.module.common.utils.Fc;

@ConfigurationProperties(prefix="jpower.feign.http")
public class FeignHttpProperties {
    private Logger.Level logLevel = Logger.Level.FULL;
    private int maxConnections = 200;
    private long timeToLive = 900L;
    private TimeUnit timeToLiveUnit = FeignHttpClientProperties.DEFAULT_TIME_TO_LIVE_UNIT;
    private boolean followRedirects = true;
    private int connectionTimeout = 2000;
    private boolean disableSslValidation = false;
    private boolean retryOnConnectionFailure = true;
    private int readTimeout = 30000;
    private int writeTimeout = 30000;
    private int callTimeout = this.readTimeout + this.writeTimeout + 10000;

    public FeignHttpProperties() {
        String profile = EnvBeanUtil.getProfile();
        if (Fc.equals((Object)profile, (Object)"prod")) {
            this.logLevel = Logger.Level.BASIC;
        }
    }

    public Logger.Level getLogLevel() {
        return this.logLevel;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }

    public TimeUnit getTimeToLiveUnit() {
        return this.timeToLiveUnit;
    }

    public boolean isFollowRedirects() {
        return this.followRedirects;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public boolean isDisableSslValidation() {
        return this.disableSslValidation;
    }

    public boolean isRetryOnConnectionFailure() {
        return this.retryOnConnectionFailure;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public int getWriteTimeout() {
        return this.writeTimeout;
    }

    public int getCallTimeout() {
        return this.callTimeout;
    }

    public void setLogLevel(Logger.Level logLevel) {
        this.logLevel = logLevel;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public void setTimeToLive(long timeToLive) {
        this.timeToLive = timeToLive;
    }

    public void setTimeToLiveUnit(TimeUnit timeToLiveUnit) {
        this.timeToLiveUnit = timeToLiveUnit;
    }

    public void setFollowRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setDisableSslValidation(boolean disableSslValidation) {
        this.disableSslValidation = disableSslValidation;
    }

    public void setRetryOnConnectionFailure(boolean retryOnConnectionFailure) {
        this.retryOnConnectionFailure = retryOnConnectionFailure;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setWriteTimeout(int writeTimeout) {
        this.writeTimeout = writeTimeout;
    }

    public void setCallTimeout(int callTimeout) {
        this.callTimeout = callTimeout;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FeignHttpProperties)) {
            return false;
        }
        FeignHttpProperties other = (FeignHttpProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMaxConnections() != other.getMaxConnections()) {
            return false;
        }
        if (this.getTimeToLive() != other.getTimeToLive()) {
            return false;
        }
        if (this.isFollowRedirects() != other.isFollowRedirects()) {
            return false;
        }
        if (this.getConnectionTimeout() != other.getConnectionTimeout()) {
            return false;
        }
        if (this.isDisableSslValidation() != other.isDisableSslValidation()) {
            return false;
        }
        if (this.isRetryOnConnectionFailure() != other.isRetryOnConnectionFailure()) {
            return false;
        }
        if (this.getReadTimeout() != other.getReadTimeout()) {
            return false;
        }
        if (this.getWriteTimeout() != other.getWriteTimeout()) {
            return false;
        }
        if (this.getCallTimeout() != other.getCallTimeout()) {
            return false;
        }
        Logger.Level this$logLevel = this.getLogLevel();
        Logger.Level other$logLevel = other.getLogLevel();
        if (this$logLevel == null ? other$logLevel != null : !this$logLevel.equals(other$logLevel)) {
            return false;
        }
        TimeUnit this$timeToLiveUnit = this.getTimeToLiveUnit();
        TimeUnit other$timeToLiveUnit = other.getTimeToLiveUnit();
        return !(this$timeToLiveUnit == null ? other$timeToLiveUnit != null : !((Object)((Object)this$timeToLiveUnit)).equals((Object)other$timeToLiveUnit));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FeignHttpProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMaxConnections();
        long $timeToLive = this.getTimeToLive();
        result = result * 59 + (int)($timeToLive >>> 32 ^ $timeToLive);
        result = result * 59 + (this.isFollowRedirects() ? 79 : 97);
        result = result * 59 + this.getConnectionTimeout();
        result = result * 59 + (this.isDisableSslValidation() ? 79 : 97);
        result = result * 59 + (this.isRetryOnConnectionFailure() ? 79 : 97);
        result = result * 59 + this.getReadTimeout();
        result = result * 59 + this.getWriteTimeout();
        result = result * 59 + this.getCallTimeout();
        Logger.Level $logLevel = this.getLogLevel();
        result = result * 59 + ($logLevel == null ? 43 : $logLevel.hashCode());
        TimeUnit $timeToLiveUnit = this.getTimeToLiveUnit();
        result = result * 59 + ($timeToLiveUnit == null ? 43 : ((Object)((Object)$timeToLiveUnit)).hashCode());
        return result;
    }

    public String toString() {
        return "FeignHttpProperties(logLevel=" + this.getLogLevel() + ", maxConnections=" + this.getMaxConnections() + ", timeToLive=" + this.getTimeToLive() + ", timeToLiveUnit=" + (Object)((Object)this.getTimeToLiveUnit()) + ", followRedirects=" + this.isFollowRedirects() + ", connectionTimeout=" + this.getConnectionTimeout() + ", disableSslValidation=" + this.isDisableSslValidation() + ", retryOnConnectionFailure=" + this.isRetryOnConnectionFailure() + ", readTimeout=" + this.getReadTimeout() + ", writeTimeout=" + this.getWriteTimeout() + ", callTimeout=" + this.getCallTimeout() + ")";
    }
}

