/*
 * Decompiled with CFR 0.152.
 */
package top.jpower.jpower.sentinel.datascource;

import com.alibaba.csp.sentinel.datasource.nacos.NacosDataSource;
import com.alibaba.csp.sentinel.property.SentinelProperty;
import com.alibaba.csp.sentinel.slots.block.authority.AuthorityRule;
import com.alibaba.csp.sentinel.slots.block.authority.AuthorityRuleManager;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRule;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRuleManager;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRuleManager;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRuleManager;
import com.alibaba.csp.sentinel.slots.system.SystemRule;
import com.alibaba.csp.sentinel.slots.system.SystemRuleManager;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.TypeReference;
import java.util.List;
import java.util.Properties;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class SentinelNacosDataSource {
    @Value(value="${spring.cloud.nacos.config.server-addr}")
    private String remoteAddress;
    @Value(value="${spring.cloud.nacos.config.namespace:}")
    private String nacosNamespace;
    private String groupId = "SENTINEL_GROUP";
    @Value(value="#{'${spring.application.name}'.concat('-sentinel')}")
    private String dataId;

    @PostConstruct
    public void init() {
        Properties properties = new Properties();
        properties.put("serverAddr", this.remoteAddress);
        properties.put("namespace", this.nacosNamespace);
        NacosDataSource flowRuleDataSource = new NacosDataSource(properties, this.groupId, this.dataId.concat("-flow"), source -> (List)JSON.parseObject((String)source, (TypeReference)new TypeReference<List<FlowRule>>(){}, (JSONReader.Feature[])new JSONReader.Feature[0]));
        FlowRuleManager.register2Property((SentinelProperty)flowRuleDataSource.getProperty());
        NacosDataSource degradeRuleDataSource = new NacosDataSource(properties, this.groupId, this.dataId.concat("-degrade"), source -> (List)JSON.parseObject((String)source, (TypeReference)new TypeReference<List<DegradeRule>>(){}, (JSONReader.Feature[])new JSONReader.Feature[0]));
        DegradeRuleManager.register2Property((SentinelProperty)degradeRuleDataSource.getProperty());
        NacosDataSource paramFlowRuleDataSource = new NacosDataSource(properties, this.groupId, this.dataId.concat("-paramFlow"), source -> (List)JSON.parseObject((String)source, (TypeReference)new TypeReference<List<ParamFlowRule>>(){}, (JSONReader.Feature[])new JSONReader.Feature[0]));
        ParamFlowRuleManager.register2Property((SentinelProperty)paramFlowRuleDataSource.getProperty());
        NacosDataSource systemRuleDataSource = new NacosDataSource(properties, this.groupId, this.dataId.concat("-system"), source -> (List)JSON.parseObject((String)source, (TypeReference)new TypeReference<List<SystemRule>>(){}, (JSONReader.Feature[])new JSONReader.Feature[0]));
        SystemRuleManager.register2Property((SentinelProperty)systemRuleDataSource.getProperty());
        NacosDataSource authorityRuleDataSource = new NacosDataSource(properties, this.groupId, this.dataId.concat("-authority"), source -> (List)JSON.parseObject((String)source, (TypeReference)new TypeReference<List<AuthorityRule>>(){}, (JSONReader.Feature[])new JSONReader.Feature[0]));
        AuthorityRuleManager.register2Property((SentinelProperty)authorityRuleDataSource.getProperty());
    }
}

