/*
 * Decompiled with CFR 0.152.
 */
package top.jpower.jpower.module.common.swagger;

import com.github.xiaoymin.knife4j.spring.extension.OpenApiExtensionResolver;
import com.google.common.base.Function;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.bind.annotation.RequestMethod;
import springfox.bean.validators.configuration.BeanValidatorPluginsConfiguration;
import springfox.documentation.RequestHandler;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.ApiKey;
import springfox.documentation.service.AuthorizationScope;
import springfox.documentation.service.Contact;
import springfox.documentation.service.SecurityReference;
import springfox.documentation.service.SecurityScheme;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.contexts.SecurityContext;
import springfox.documentation.spring.web.plugins.Docket;
import top.jpower.jpower.module.common.deploy.props.JpowerProperties;
import top.jpower.jpower.module.common.swagger.SwaggerProperties;
import top.jpower.jpower.module.common.utils.ClassUtil;
import top.jpower.jpower.module.common.utils.Fc;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={SwaggerProperties.class})
@ConditionalOnProperty(prefix="knife4j", name={"enable"}, havingValue="true", matchIfMissing=false)
@Import(value={BeanValidatorPluginsConfiguration.class})
public class SwaggerConfiguration {
    private final JpowerProperties properties;
    private final OpenApiExtensionResolver openApiExtensionResolver;

    private com.google.common.base.Predicate<RequestHandler> basePackage(List<String> basePackage) {
        return input -> this.declaringClass((RequestHandler)input).map(this.handlerPackage(basePackage)).orElse(true);
    }

    private Function<Class<?>, Boolean> handlerPackage(List<String> basePackage) {
        return input -> basePackage.stream().anyMatch(ClassUtil.getPackage((Class)input)::startsWith);
    }

    private Optional<? extends Class<?>> declaringClass(RequestHandler input) {
        return Optional.ofNullable(input.declaringClass());
    }

    @Bean
    @ConditionalOnMissingBean
    public Docket createRestApi(SwaggerProperties swaggerProperties) {
        ArrayList<com.google.common.base.Predicate> basePath = new ArrayList<com.google.common.base.Predicate>();
        for (String path : swaggerProperties.getBasePath()) {
            basePath.add(input -> new AntPathMatcher().match(path, input));
        }
        ArrayList<com.google.common.base.Predicate> excludePath = new ArrayList<com.google.common.base.Predicate>();
        for (String path : swaggerProperties.getExcludePath()) {
            excludePath.add(input -> new AntPathMatcher().match(path, input));
        }
        return new Docket(DocumentationType.SWAGGER_2).globalResponseMessage(RequestMethod.POST, new ArrayList()).globalResponseMessage(RequestMethod.GET, new ArrayList()).globalResponseMessage(RequestMethod.PUT, new ArrayList()).globalResponseMessage(RequestMethod.DELETE, new ArrayList()).host(swaggerProperties.getHost()).apiInfo(this.apiInfo(swaggerProperties)).select().apis(this.basePackage(swaggerProperties.getBasePackage())).paths((Predicate)Predicates.and((com.google.common.base.Predicate)Predicates.not((com.google.common.base.Predicate)Predicates.or(excludePath)), (com.google.common.base.Predicate)Predicates.or(basePath))).paths(PathSelectors.any()).build().securitySchemes(this.securitySchemes(swaggerProperties)).securityContexts((List)Lists.newArrayList(this.securityContexts(swaggerProperties))).extensions(this.openApiExtensionResolver.buildExtensions(Fc.isBlank((CharSequence)swaggerProperties.getGroupName()) ? this.properties.getApplicationName() : swaggerProperties.getGroupName())).pathMapping("/");
    }

    private List<? extends SecurityScheme> securitySchemes(SwaggerProperties swaggerProperties) {
        ArrayList list = new ArrayList();
        swaggerProperties.getAuthorization().forEach(authorization -> list.add(new ApiKey(authorization.getName(), authorization.getName(), authorization.getType())));
        return list;
    }

    private List<SecurityContext> securityContexts(SwaggerProperties swaggerProperties) {
        return Lists.newArrayList((Object[])new SecurityContext[]{SecurityContext.builder().securityReferences(this.defaultAuth(swaggerProperties)).forPaths(PathSelectors.regex((String)"^(?!auth).*$")).build()});
    }

    private List<SecurityReference> defaultAuth(SwaggerProperties swaggerProperties) {
        ArrayList<SecurityReference> securityReferences = new ArrayList<SecurityReference>();
        swaggerProperties.getAuthorization().forEach(authorization -> securityReferences.add(new SecurityReference(authorization.getName(), authorization.getAuthorizationScopes().toArray(new AuthorizationScope[authorization.getAuthorizationScopes().size()]))));
        return securityReferences;
    }

    private ApiInfo apiInfo(SwaggerProperties properties) {
        return new ApiInfoBuilder().title(properties.getTitle()).description(properties.getDescription()).license(properties.getLicense()).licenseUrl(properties.getLicenseUrl()).termsOfServiceUrl(properties.getTermsOfServiceUrl()).contact(new Contact(properties.getContact().getName(), properties.getContact().getUrl(), properties.getContact().getEmail())).version(properties.getVersion()).build();
    }

    public SwaggerConfiguration(JpowerProperties properties, OpenApiExtensionResolver openApiExtensionResolver) {
        this.properties = properties;
        this.openApiExtensionResolver = openApiExtensionResolver;
    }
}

