/*
 * Decompiled with CFR 0.152.
 */
package top.jpower.jpower.web;

import io.swagger.models.Swagger;
import javax.servlet.http.HttpServletRequest;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.util.UriComponents;
import springfox.documentation.annotations.ApiIgnore;
import springfox.documentation.service.Documentation;
import springfox.documentation.spring.web.DocumentationCache;
import springfox.documentation.spring.web.PropertySourcedMapping;
import springfox.documentation.spring.web.json.Json;
import springfox.documentation.spring.web.json.JsonSerializer;
import springfox.documentation.swagger.common.HostNameProvider;
import springfox.documentation.swagger2.annotations.EnableSwagger2WebMvc;
import springfox.documentation.swagger2.mappers.ServiceModelToSwagger2Mapper;

@Controller
@EnableSwagger2WebMvc
@ConditionalOnClass(name={"javax.servlet.http.HttpServletRequest"})
@ApiIgnore
public class AllControllerWebMvc {
    private static final String HAL_MEDIA_TYPE = "application/hal+json";
    private final DocumentationCache documentationCache;
    private final ServiceModelToSwagger2Mapper mapper;
    private final JsonSerializer jsonSerializer;

    @RequestMapping(value={"/all/restful"}, method={RequestMethod.GET}, produces={"application/json", "application/hal+json"})
    @PropertySourcedMapping(value="${springfox.documentation.swagger.v2.path}", propertyKey="springfox.documentation.swagger.v2.path")
    @ResponseBody
    public ResponseEntity<Json> getDocumentation(HttpServletRequest servletRequest) {
        Swagger swagger;
        Documentation documentation = this.documentationCache.documentationByGroup("default");
        UriComponents uriComponents = HostNameProvider.componentsFrom((HttpServletRequest)servletRequest, (String)(swagger = this.mapper.mapDocumentation(documentation)).getBasePath());
        swagger.basePath(StringUtils.isEmpty((Object)uriComponents.getPath()) ? "/" : uriComponents.getPath());
        if (StringUtils.isEmpty((Object)swagger.getHost())) {
            swagger.host(this.hostName(uriComponents));
        }
        return new ResponseEntity((Object)this.jsonSerializer.toJson((Object)swagger), HttpStatus.OK);
    }

    private String hostName(UriComponents uriComponents) {
        String host = uriComponents.getHost();
        int port = uriComponents.getPort();
        if (port > -1) {
            return String.format("%s:%d", host, port);
        }
        return host;
    }

    public AllControllerWebMvc(DocumentationCache documentationCache, ServiceModelToSwagger2Mapper mapper, JsonSerializer jsonSerializer) {
        this.documentationCache = documentationCache;
        this.mapper = mapper;
        this.jsonSerializer = jsonSerializer;
    }
}

