package top.kagg886.pixko.module.profile

/**
 * # 地址字段序列化结果
 */
enum class JapanAddress(private val display: String, val code: Int) {
    UN_SETTING("未设置", 0),
    HOKKAIDO("北海道", 1),
    AOMORI("青森县", 2),
    IWATE("岩手县", 3),
    MIYAGI("宫城县", 4),
    AKITA("秋田县", 5),
    YAMAGATA("山形县", 6),
    FUKUSHIMA("福岛县", 7),
    IBARAKI("茨城县", 8),
    TOCHIGI("栃木县", 9),
    GUMMA("群马县", 10),
    SAITAMA("埼玉县", 11),
    CHIBA("千叶县", 12),
    TOKYO("东京都", 13),
    KANAGAWA("神奈川县", 14),
    NIIGATA("新潟县", 15),
    TOYAMA("富山县", 16),
    ISHIKAWA("石川县", 17),
    FUKUI("福井县", 18),
    YAMANASHI("山梨县", 19),
    NAGANO("长野县", 20),
    GIFU("岐阜县", 21),
    SHIZUOKA("静冈县", 22),
    AICHI("爱知县", 23),
    MIE("三重县", 24),
    SHIGA("滋贺县", 25),
    KYOTO("京都府", 26),
    OSAKA("大阪府", 27),
    HYOGO("兵库县", 28),
    NARA("奈良县", 29),
    WAKAYAMA("和歌山县", 30),
    TOTTORI("鸟取县", 31),
    SHIMANE("岛根县", 32),
    OKAYAMA("冈山县", 33),
    HIROSHIMA("广岛县", 34),
    YAMAGUCHI("山口县", 35),
    TOKUSHIMA("德岛县", 36),
    KAGAWA("香川县", 37),
    EHIME("爱媛县", 38),
    KOCHI("高知县", 39),
    FUKUOKA("福冈县", 40),
    SAGA("佐贺县", 41),
    NAGASAKI("长崎县", 42),
    KUMAMOTO("熊本县", 43),
    OITA("大分县", 44),
    MIYAZAKI("宫崎县", 45),
    KAGOSHIMA("鹿儿岛县", 46),
    OKINAWA("冲绳县", 47),
    INTERNATIONAL("国际", 48);

    companion object {
        fun fromCode(code: Int): JapanAddress? = entries.firstOrNull { it.code == code }
    }

    override fun toString(): String = display
}

/**
 * # 国家序列化结果
 * @property display 显示名称
 * @property code 国家代码
 */
enum class CountryCode(private val display: String, val code: String) {
    UN_SETTING("未设置", ""),
    JAPAN("日本", ""),
    ICELAND("冰岛", "IS"),
    IRELAND("爱尔兰", "IE"),
    AZERBAIJAN("阿塞拜疆", "AZ"),
    AFGHANISTAN("阿富汗", "AF"),
    UNITED_STATES("美国", "US"),
    VIRGIN_ISLANDS_US("美属维尔京群岛", "VI"),
    AMERICAN_SAMOA("美属萨摩亚", "AS"),
    UNITED_STATES_MINOR_OUTLYING_ISLANDS("美国本土外小群岛", "UM"),
    UNITED_ARAB_EMIRATES("阿拉伯联合酋长国", "AE"),
    ALGERIA("阿尔及利亚", "DZ"),
    ARGENTINA("阿根廷", "AR"),
    ARUBA("阿鲁巴", "AW"),
    ALBANIA("阿尔巴尼亚", "AL"),
    ARMENIA("亚美尼亚", "AM"),
    ANGUILLA("安圭拉", "AI"),
    ANGOLA("安哥拉", "AO"),
    ANTIGUA_AND_BARBUDA("安提瓜和巴布达", "AG"),
    ANDORRA("安道尔", "AD"),
    YEMEN("也门", "YE"),
    UNITED_KINGDOM("英国", "GB"),
    BRITISH_INDIAN_OCEAN_TERRITORY("英属印度洋领地", "IO"),
    VIRGIN_ISLANDS_BRITISH("英属维尔京群岛", "VG"),
    ISRAEL("以色列", "IL"),
    ITALY("意大利", "IT"),
    IRAQ("伊拉克", "IQ"),
    IRAN("伊朗", "IR"),
    INDIA("印度", "IN"),
    INDONESIA("印度尼西亚", "ID"),
    UGANDA("乌干达", "UG"),
    UKRAINE("乌克兰", "UA"),
    UZBEKISTAN("乌兹别克斯坦", "UZ"),
    URUGUAY("乌拉圭", "UY"),
    ECUADOR("厄瓜多尔", "EC"),
    EGYPT("埃及", "EG"),
    ESTONIA("爱沙尼亚", "EE"),
    ETHIOPIA("埃塞俄比亚", "ET"),
    ERITREA("厄立特里亚", "ER"),
    EL_SALVADOR("萨尔瓦多", "SV"),
    AUSTRALIA("澳大利亚", "AU"),
    AUSTRIA("奥地利", "AT"),
    AALAND_ISLANDS("奥兰群岛", "AX"),
    OMAN("阿曼", "OM"),
    NETHERLANDS("荷兰", "NL"),
    NETHERLANDS_ANTILLES("荷属安的列斯", "AN"),
    GHANA("加纳", "GH"),
    GUERNSEY("根西岛", "GG"),
    GUYANA("圭亚那", "GY"),
    KAZAKHSTAN("哈萨克斯坦", "KZ"),
    QATAR("卡塔尔", "QA"),
    CANADA("加拿大", "CA"),
    CAPE_VERDE("佛得角", "CV"),
    GABON("加蓬", "GA"),
    CAMEROON("喀麦隆", "CM"),
    GAMBIA("冈比亚", "GM"),
    CAMBODIA("柬埔寨", "KH"),
    NORTHERN_MARIANA_ISLANDS("北马里亚纳群岛", "MP"),
    GUINEA("几内亚", "GN"),
    GUINEA_BISSAU("几内亚比绍", "GW"),
    CYPRUS("塞浦路斯", "CY"),
    CUBA("古巴", "CU"),
    GREECE("希腊", "GR"),
    KIRIBATI("基里巴斯", "KI"),
    KYRGYZSTAN("吉尔吉斯斯坦", "KG"),
    GUATEMALA("危地马拉", "GT"),
    GUADELOUPE("瓜德罗普", "GP"),
    GUAM("关岛", "GU"),
    KUWAIT("科威特", "KW"),
    COOK_ISLANDS("库克群岛", "CK"),
    GREENLAND("格陵兰", "GL"),
    CHRISTMAS_ISLAND("圣诞岛", "CX"),
    GEORGIA("格鲁吉亚", "GE"),
    GRENADA("格林纳达", "GD"),
    CROATIA("克罗地亚", "HR"),
    CAYMAN_ISLANDS("开曼群岛", "KY"),
    KENYA("肯尼亚", "KE"),
    COTE_DIVOIRE("科特迪瓦", "CI"),
    COCOS_KEELING_ISLANDS("科科斯（基林）群岛", "CC"),
    COSTA_RICA("哥斯达黎加", "CR"),
    COMOROS("科摩罗", "KM"),
    COLOMBIA("哥伦比亚", "CO"),
    CONGO("刚果", "CG"),
    DEMOCRATIC_REPUBLIC_OF_THE_CONGO("刚果民主共和国", "CD"),
    SAUDI_ARABIA("沙特阿拉伯", "SA"),
    SAMOA("萨摩亚", "WS"),
    SAO_TOME_AND_PRINCIPE("圣多美和普林西比", "ST"),
    SAINT_BARTHELEMY("圣巴泰勒米", "BL"),
    ZAMBIA("赞比亚", "ZM"),
    SAINT_PIERRE_AND_MIQUELON("圣皮埃尔和密克隆", "PM"),
    SAN_MARINO("圣马力诺", "SM"),
    SAINT_MARTIN_FRENCH_PART("圣马丁（法国部分）", "MF"),
    SIERRA_LEONE("塞拉利昂", "SL"),
    DJIBOUTI("吉布提", "DJ"),
    GIBRALTAR("直布罗陀", "GI"),
    JERSEY("泽西岛", "JE"),
    JAMAICA("牙买加", "JM"),
    SYRIAN_ARAB_REPUBLIC("叙利亚", "SY"),
    SINGAPORE("新加坡", "SG"),
    ZIMBABWE("津巴布韦", "ZW"),
    SWITZERLAND("瑞士", "CH"),
    SWEDEN("瑞典", "SE"),
    SUDAN("苏丹", "SD"),
    SVALBARD_AND_JAN_MAYEN("斯瓦尔巴群岛和扬马延岛", "SJ"),
    SPAIN("西班牙", "ES"),
    SURINAME("苏里南", "SR"),
    SRI_LANKA("斯里兰卡", "LK"),
    SLOVAKIA("斯洛伐克", "SK"),
    SLOVENIA("斯洛文尼亚", "SI"),
    SWAZILAND("斯威士兰", "SZ"),
    SEYCHELLES("塞舌尔", "SC"),
    EQUATORIAL_GUINEA("赤道几内亚", "GQ"),
    SENEGAL("塞内加尔", "SN"),
    SERBIA("塞尔维亚", "RS"),
    SAINT_KITTS_AND_NEVIS("圣基茨和尼维斯", "KN"),
    SAINT_VINCENT_AND_THE_GRENADINES("圣文森特和格林纳丁斯", "VC"),
    SAINT_HELENA("圣赫勒拿", "SH"),
    SAINT_LUCIA("圣卢西亚", "LC"),
    SOMALIA("索马里", "SO"),
    SOLOMON_ISLANDS("所罗门群岛", "SB"),
    TURKS_AND_CAICOS_ISLANDS("特克斯和凯科斯群岛", "TC"),
    THAILAND("泰国", "TH"),
    KOREA_REPUBLIC_OF("韩国", "KR"),
    TAIWAN("台湾", "TW"),
    TAJIKISTAN("塔吉克斯坦", "TJ"),
    TANZANIA_UNITED_REPUBLIC_OF("坦桑尼亚", "TZ"),
    CZECH_REPUBLIC("捷克共和国", "CZ"),
    CHAD("乍得", "TD"),
    CENTRAL_AFRICAN_REPUBLIC("中非共和国", "CF"),
    CHINA("中国", "CN"),
    TUNISIA("突尼斯", "TN"),
    KOREA_DEMOCRATIC_PEOPLES_REPUBLIC_OF("朝鲜", "KP"),
    CHILE("智利", "CL"),
    TUVALU("图瓦卢", "TV"),
    DENMARK("丹麦", "DK"),
    GERMANY("德国", "DE"),
    TOGO("多哥", "TG"),
    TOKELAU("托克劳", "TK"),
    DOMINICAN_REPUBLIC("多米尼加共和国", "DO"),
    DOMINICA("多米尼克", "DM"),
    TRINIDAD_AND_TOBAGO("特立尼达和多巴哥", "TT"),
    TURKMENISTAN("土库曼斯坦", "TM"),
    TURKEY("土耳其", "TR"),
    TONGA("汤加", "TO"),
    NIGERIA("尼日利亚", "NG"),
    NAURU("瑙鲁", "NR"),
    NAMIBIA("纳米比亚", "NA"),
    ANTARCTICA("南极洲", "AQ"),
    NIUE("纽埃", "NU"),
    NICARAGUA("尼加拉瓜", "NI"),
    NIGER("尼日尔", "NE"),
    WESTERN_SAHARA("西撒哈拉", "EH"),
    NEW_CALEDONIA("新喀里多尼亚", "NC"),
    NEW_ZEALAND("新西兰", "NZ"),
    NEPAL("尼泊尔", "NP"),
    NORFOLK_ISLAND("诺福克岛", "NF"),
    NORWAY("挪威", "NO"),
    BAHRAIN("巴林", "BH"),
    HAITI("海地", "HT"),
    PAKISTAN("巴基斯坦", "PK"),
    HOLY_SEE_VATICAN_CITY_STATE("梵蒂冈城国", "VA"),
    PANAMA("巴拿马", "PA"),
    VANUATU("瓦努阿图", "VU"),
    BAHAMAS("巴哈马", "BS"),
    PAPUA_NEW_GUINEA("巴布亚新几内亚", "PG"),
    BERMUDA("百慕大", "BM"),
    PALAU("帕劳", "PW"),
    PARAGUAY("巴拉圭", "PY"),
    BARBADOS("巴巴多斯", "BB"),
    PALESTINIAN_TERRITORY_OCCUPIED("巴勒斯坦被占领土", "PS"),
    HUNGARY("匈牙利", "HU"),
    BANGLADESH("孟加拉国", "BD"),
    TIMOR_LESTE("东帝汶", "TL"),
    PITCAIRN("皮特凯恩群岛", "PN"),
    FIJI("斐济", "FJ"),
    PHILIPPINES("菲律宾", "PH"),
    FINLAND("芬兰", "FI"),
    BHUTAN("不丹", "BT"),
    BOUVET_ISLAND("布韦岛", "BV"),
    PUERTO_RICO("波多黎各", "PR"),
    FAROE_ISLANDS("法罗群岛", "FO"),
    FALKLAND_ISLANDS_MALVINAS("福克兰群岛", "FK"),
    BRAZIL("巴西", "BR"),
    FRANCE("法国", "FR"),
    FRENCH_GUIANA("法属圭亚那", "GF"),
    FRENCH_POLYNESIA("法属波利尼西亚", "PF"),
    FRENCH_SOUTHERN_TERRITORIES("法属南部领地", "TF"),
    BULGARIA("保加利亚", "BG"),
    BURKINA_FASO("布基纳法索", "BF"),
    BRUNEI_DARUSSALAM("文莱", "BN"),
    BURUNDI("布隆迪", "BI"),
    HEARD_ISLAND_AND_MCDONALD_ISLANDS("赫德岛和麦克唐纳群岛", "HM"),
    VIET_NAM("越南", "VN"),
    BENIN("贝宁", "BJ"),
    VENEZUELA("委内瑞拉", "VE"),
    BELARUS("白俄罗斯", "BY"),
    BELIZE("伯利兹", "BZ"),
    PERU("秘鲁", "PE"),
    BELGIUM("比利时", "BE"),
    POLAND("波兰", "PL"),
    BOSNIA_AND_HERZEGOVINA("波斯尼亚和黑塞哥维那", "BA"),
    BOTSWANA("博茨瓦纳", "BW"),
    BOLIVIA("玻利维亚", "BO"),
    PORTUGAL("葡萄牙", "PT"),
    HONG_KONG("香港", "HK"),
    HONDURAS("洪都拉斯", "HN"),
    MARSHALL_ISLANDS("马绍尔群岛", "MH"),
    MACAO("澳门", "MO"),
    MACEDONIA_THE_FORMER_YUGOSLAV_REPUBLIC_OF("北马其顿", "MK"),
    MADAGASCAR("马达加斯加", "MG"),
    MAYOTTE("马约特", "YT"),
    MALAWI("马拉维", "MW"),
    MALLI("马里", "ML"),
    MALTA("马耳他", "MT"),
    MARTINIQUE("马提尼克", "MQ"),
    MALAYSIA("马来西亚", "MY"),
    ISLE_OF_MAN("马恩岛", "IM"),
    MICRONESIA_FEDERATED_STATES_OF("密克罗尼西亚联邦", "FM"),
    SOUTH_AFRICA("南非", "ZA"),
    SOUTH_GEORGIA_AND_THE_SOUTH_SANDWICH_ISLANDS("南乔治亚岛和南桑威奇群岛", "GS"),
    MYANMAR("缅甸", "MM"),
    MEXICO("墨西哥", "MX"),
    MAURITIUS("毛里求斯", "MU"),
    MAURITANIA("毛里塔尼亚", "MR"),
    MOZAMBIQUE("莫桑比克", "MZ"),
    MONACO("摩纳哥", "MC"),
    MALDIVES("马尔代夫", "MV"),
    MOLDOVA_REPUBLIC_OF("摩尔多瓦共和国", "MD"),
    MOROCCO("摩洛哥", "MA"),
    MONGOLIA("蒙古", "MN"),
    MONTENEGRO("黑山", "ME"),
    MONTserrat("蒙特塞拉特", "MS"),
    JORDAN("约旦", "JO"),
    LAO_PEOPLE_S_DEMOCRATIC_REPUBLIC("老挝人民民主共和国", "LA"),
    LATVIA("拉脱维亚", "LV"),
    LITHUANIA("立陶宛", "LT"),
    LIBYAN_ARAB_JAMAHIRIYA("利比亚阿拉伯民众国", "LY"),
    LIECHTENSTEIN("列支敦士登", "LI"),
    LIBERIA("利比里亚", "LR"),
    ROMANIA("罗马尼亚", "RO"),
    LUXEMBOURG("卢森堡", "LU"),
    RWANDA("卢旺达", "RW"),
    LESOTHO("莱索托", "LS"),
    LEBANON("黎巴嫩", "LB"),
    REUNION("留尼汪", "RE"),
    RUSSIAN_FEDERATION("俄罗斯联邦", "RU"),
    WALLIS_AND_FUTUNA("瓦利斯和富图纳群岛", "WF"),

    BONAIRE_SINT_EUSTATIUS_AND_SABA("博内尔、圣尤斯特歇斯和萨巴", "BQ"),
    CURACAO("库拉索", "CW"),
    KOSOVO("科索沃", "KV");

    override fun toString(): String = display

    companion object {
        fun fromCode(code: String): CountryCode {
            return entries.first { it.code == code }
        }
    }
}

enum class Job(val code: Int, private val display: String) {
    UN_SETTING(0, "未设置"),
    IT_ASSOCIATED(1, "IT关联"),
    AFFAIRS_ASSOCIATED(2, "事务关联"),
    TECHNOLOGY_ASSOCIATED(3, "技术关联"),
    BUSINESS_PLANNING_ASSOCIATED(4, "营业/企划关联"),
    CREATIVE_ASSOCIATED(5, "创作关联"),
    SALES_ASSOCIATED(6, "贩卖关联"),
    SERVICE_ASSOCIATED(7, "服务关联"),
    SHORT_COAT_HELP(8, "短衣帮"),
    EXECUTIVE_ADMINISTRATION(9, "高管/行政管理"),
    SPECIAL_PROFESSION(10, "专门职业"),
    CIVIL_SERVANT(11, "公务员"),
    TEACHER(12, "教师"),
    SELF_EMPLOYED(13, "自雇"),
    ARTIST(14, "艺术家"),
    FREELANCER(15, "飛特族"),
    ELEMENTARY_SCHOOL_STUDENT(16, "小学生"),
    MIDDLE_SCHOOL_STUDENT(17, "中学生"),
    HIGH_SCHOOL_STUDENT(18, "高校生"),
    COLLEGE_STUDENT_GRADUATE_STUDENT(19, "大学生/研究生"),
    VOCATIONAL_SCHOOL_STUDENT(20, "学院生"),
    HOUSEWIFE(21, "家庭主妇"),
    JOB_SEEKING(22, "求职中"),
    OTHER(23, "其他");

    override fun toString(): String = display

    companion object {
        fun fromCode(code: Int): Job {
            return entries.first { it.code == code }
        }
    }
}
