/*
 * Decompiled with CFR 0.152.
 */
package top.kagg886.pixko.module.novel.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import top.kagg886.pixko.module.novel.parser.NovelContentBlockType;
import top.kagg886.pixko.module.novel.parser.TextNode;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f\u001a\u0010\u0010\r\u001a\u00020\f*\b\u0012\u0004\u0012\u00020\n0\t\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"JUMP_URI_REGEX", "Lkotlin/text/Regex;", "NOTATION_REGEX", "UPLOAD_IMAGE_REGEX", "PIXIV_IMAGE_REGEX", "NEW_PAGE_REGEX", "CHAPTER_REGEX", "JUMP_PAGE_REGEX", "createNovelData", "", "Ltop/kagg886/pixko/module/novel/parser/TextNode;", "str", "", "toOriginalString", "pixko"})
@SourceDebugExtension(value={"SMAP\nparse.kt\nKotlin\n*S Kotlin\n*F\n+ 1 parse.kt\ntop/kagg886/pixko/module/novel/parser/ParseKt\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,81:1\n1317#2,2:82\n1317#2,2:84\n1317#2,2:86\n1317#2,2:88\n1317#2,2:90\n1317#2,2:92\n1317#2,2:94\n1010#3,2:96\n1010#3,2:98\n1863#3,2:100\n*S KotlinDebug\n*F\n+ 1 parse.kt\ntop/kagg886/pixko/module/novel/parser/ParseKt\n*L\n16#1:82,2\n19#1:84,2\n22#1:86,2\n25#1:88,2\n28#1:90,2\n31#1:92,2\n34#1:94,2\n37#1:96,2\n58#1:98,2\n66#1:100,2\n*E\n"})
public final class ParseKt {
    @NotNull
    private static final Regex JUMP_URI_REGEX = new Regex("\\[\\[jumpuri:(.*)>(.*)]]");
    @NotNull
    private static final Regex NOTATION_REGEX = new Regex("\\[\\[rb:(.*)>(.*)]]");
    @NotNull
    private static final Regex UPLOAD_IMAGE_REGEX = new Regex("\\[uploadedimage:(.*)]");
    @NotNull
    private static final Regex PIXIV_IMAGE_REGEX = new Regex("\\[pixivimage:(.*)]");
    @NotNull
    private static final Regex NEW_PAGE_REGEX = new Regex("\\[newpage]");
    @NotNull
    private static final Regex CHAPTER_REGEX = new Regex("\\[chapter:(.*)]");
    @NotNull
    private static final Regex JUMP_PAGE_REGEX = new Regex("\\[jump:(.*)]");

    @NotNull
    public static final List<TextNode> createNovelData(@NotNull String str) {
        MatchResult i;
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        List result = new ArrayList();
        Sequence $this$forEach$iv = Regex.findAll$default((Regex)JUMP_URI_REGEX, (CharSequence)str, (int)0, (int)2, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            i = (MatchResult)element$iv;
            boolean bl = false;
            result.add(new TextNode(NovelContentBlockType.JUMP_URI, (String)i.getGroupValues().get(1), (String)i.getGroupValues().get(2), i.getRange()));
        }
        $this$forEach$iv = Regex.findAll$default((Regex)NOTATION_REGEX, (CharSequence)str, (int)0, (int)2, null);
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            i = (MatchResult)element$iv;
            boolean bl = false;
            result.add(new TextNode(NovelContentBlockType.NOTATION, (String)i.getGroupValues().get(1), (String)i.getGroupValues().get(2), i.getRange()));
        }
        $this$forEach$iv = Regex.findAll$default((Regex)UPLOAD_IMAGE_REGEX, (CharSequence)str, (int)0, (int)2, null);
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            i = (MatchResult)element$iv;
            boolean bl = false;
            result.add(new TextNode(NovelContentBlockType.UPLOAD_IMAGE, (String)i.getGroupValues().get(1), null, i.getRange()));
        }
        $this$forEach$iv = Regex.findAll$default((Regex)PIXIV_IMAGE_REGEX, (CharSequence)str, (int)0, (int)2, null);
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            i = (MatchResult)element$iv;
            boolean bl = false;
            result.add(new TextNode(NovelContentBlockType.PIXIV_IMAGE, (String)i.getGroupValues().get(1), null, i.getRange()));
        }
        $this$forEach$iv = Regex.findAll$default((Regex)NEW_PAGE_REGEX, (CharSequence)str, (int)0, (int)2, null);
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            i = (MatchResult)element$iv;
            boolean bl = false;
            result.add(new TextNode(NovelContentBlockType.NEW_PAGE, null, null, i.getRange()));
        }
        $this$forEach$iv = Regex.findAll$default((Regex)CHAPTER_REGEX, (CharSequence)str, (int)0, (int)2, null);
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            i = (MatchResult)element$iv;
            boolean bl = false;
            result.add(new TextNode(NovelContentBlockType.TITLE, (String)i.getGroupValues().get(1), null, i.getRange()));
        }
        $this$forEach$iv = Regex.findAll$default((Regex)JUMP_PAGE_REGEX, (CharSequence)str, (int)0, (int)2, null);
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            i = (MatchResult)element$iv;
            boolean bl = false;
            result.add(new TextNode(NovelContentBlockType.JUMP_PAGE, (String)i.getGroupValues().get(1), null, i.getRange()));
        }
        List $this$sortBy$iv = result;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    TextNode it = (TextNode)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getPosition().getFirst());
                    it = (TextNode)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getPosition().getFirst()));
                }
            });
        }
        if (result.isEmpty()) {
            return CollectionsKt.listOf((Object)new TextNode(NovelContentBlockType.PLAIN, str, null, new IntRange(0, str.length())));
        }
        int index = -1;
        int n = ((Collection)result).size();
        for (int i2 = 0; i2 < n; ++i2) {
            TextNode ele = (TextNode)result.get(i2);
            String string = str.substring(index + 1, ele.getPosition().getFirst());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            result.add(new TextNode(NovelContentBlockType.PLAIN, string, null, new IntRange(index, ele.getPosition().getFirst())));
            index = ele.getPosition().getLast();
        }
        if (index < str.length()) {
            String string = str.substring(index + 1, str.length());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            result.add(new TextNode(NovelContentBlockType.PLAIN, string, null, new IntRange(index, str.length())));
        }
        List $this$sortBy$iv2 = result;
        boolean $i$f$sortBy2 = false;
        if ($this$sortBy$iv2.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv2, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    TextNode it = (TextNode)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getPosition().getFirst());
                    it = (TextNode)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getPosition().getFirst()));
                }
            });
        }
        return result;
    }

    @NotNull
    public static final String toOriginalString(@NotNull List<TextNode> $this$toOriginalString) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter($this$toOriginalString, (String)"<this>");
        StringBuilder $this$toOriginalString_u24lambda_u2410 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Iterable $this$forEach$iv = $this$toOriginalString;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            TextNode v = (TextNode)element$iv;
            boolean bl2 = false;
            switch (WhenMappings.$EnumSwitchMapping$0[v.getNovelContentBlockType().ordinal()]) {
                case 1: {
                    String string = v.getValue();
                    object = string;
                    Intrinsics.checkNotNull((Object)string);
                    break;
                }
                case 2: {
                    object = "[[jumpuri:" + v.getValue() + ">" + v.getMetadata() + "]]";
                    break;
                }
                case 3: {
                    object = "[[rb:" + v.getValue() + ">" + v.getMetadata() + "]]";
                    break;
                }
                case 4: {
                    object = "[uploadedimage:" + v.getValue() + "]";
                    break;
                }
                case 5: {
                    object = "[pixivimage:" + v.getValue() + "]";
                    break;
                }
                case 6: {
                    object = "[newpage]";
                    break;
                }
                case 7: {
                    object = "[chapter:" + v.getValue() + "]";
                    break;
                }
                case 8: {
                    object = "[jump:" + v.getValue() + "]";
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            $this$toOriginalString_u24lambda_u2410.append((String)object);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NovelContentBlockType.values().length];
            try {
                nArray[NovelContentBlockType.PLAIN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NovelContentBlockType.JUMP_URI.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NovelContentBlockType.NOTATION.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NovelContentBlockType.UPLOAD_IMAGE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NovelContentBlockType.PIXIV_IMAGE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NovelContentBlockType.NEW_PAGE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NovelContentBlockType.TITLE.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NovelContentBlockType.JUMP_PAGE.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

