/*
 * Decompiled with CFR 0.152.
 */
package top.kagg886.pixko.module.novel.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import top.kagg886.pixko.module.novel.parser.JumpPageNode;
import top.kagg886.pixko.module.novel.parser.JumpUriNode;
import top.kagg886.pixko.module.novel.parser.NewPageNode;
import top.kagg886.pixko.module.novel.parser.NotationNode;
import top.kagg886.pixko.module.novel.parser.NovelNode;
import top.kagg886.pixko.module.novel.parser.PixivImageNode;
import top.kagg886.pixko.module.novel.parser.PlainTextNode;
import top.kagg886.pixko.module.novel.parser.TitleNode;
import top.kagg886.pixko.module.novel.parser.UploadImageNode;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f\u001a\u0010\u0010\r\u001a\u00020\f*\b\u0012\u0004\u0012\u00020\n0\t\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"JUMP_URI_REGEX", "Lkotlin/text/Regex;", "NOTATION_REGEX", "UPLOAD_IMAGE_REGEX", "PIXIV_IMAGE_REGEX", "NEW_PAGE_REGEX", "CHAPTER_REGEX", "JUMP_PAGE_REGEX", "createNovelData", "", "Ltop/kagg886/pixko/module/novel/parser/NovelNode;", "str", "", "toOriginalString", "pixko"})
@SourceDebugExtension(value={"SMAP\nparse.kt\nKotlin\n*S Kotlin\n*F\n+ 1 parse.kt\ntop/kagg886/pixko/module/novel/parser/ParseKt\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,83:1\n1317#2,2:84\n1317#2,2:86\n1317#2,2:88\n1317#2:90\n1318#2:96\n1317#2,2:97\n1317#2,2:99\n1317#2,2:101\n1557#3:91\n1628#3,3:92\n1010#3,2:103\n1010#3,2:105\n1863#3,2:107\n1#4:95\n*S KotlinDebug\n*F\n+ 1 parse.kt\ntop/kagg886/pixko/module/novel/parser/ParseKt\n*L\n14#1:84,2\n17#1:86,2\n20#1:88,2\n23#1:90\n23#1:96\n30#1:97,2\n33#1:99,2\n36#1:101,2\n27#1:91\n27#1:92,3\n39#1:103,2\n60#1:105,2\n68#1:107,2\n*E\n"})
public final class ParseKt {
    @NotNull
    private static final Regex JUMP_URI_REGEX = new Regex("\\[\\[jumpuri:(.*)>(.*)]]");
    @NotNull
    private static final Regex NOTATION_REGEX = new Regex("\\[\\[rb:(.*)>(.*)]]");
    @NotNull
    private static final Regex UPLOAD_IMAGE_REGEX = new Regex("\\[uploadedimage:(.*)]");
    @NotNull
    private static final Regex PIXIV_IMAGE_REGEX = new Regex("\\[pixivimage:(.*)]");
    @NotNull
    private static final Regex NEW_PAGE_REGEX = new Regex("\\[newpage]");
    @NotNull
    private static final Regex CHAPTER_REGEX = new Regex("\\[chapter:(.*)]");
    @NotNull
    private static final Regex JUMP_PAGE_REGEX = new Regex("\\[jump:(.*)]");

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<NovelNode> createNovelData(@NotNull String str) {
        MatchResult i;
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        List result = new ArrayList();
        Sequence $this$forEach$iv = Regex.findAll$default((Regex)JUMP_URI_REGEX, (CharSequence)str, (int)0, (int)2, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            i = (MatchResult)element$iv;
            boolean bl = false;
            result.add(new JumpUriNode((String)i.getGroupValues().get(1), (String)i.getGroupValues().get(2), i.getRange()));
        }
        $this$forEach$iv = Regex.findAll$default((Regex)NOTATION_REGEX, (CharSequence)str, (int)0, (int)2, null);
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            i = (MatchResult)element$iv;
            boolean bl = false;
            result.add(new NotationNode((String)i.getGroupValues().get(1), (String)i.getGroupValues().get(2), i.getRange()));
        }
        $this$forEach$iv = Regex.findAll$default((Regex)UPLOAD_IMAGE_REGEX, (CharSequence)str, (int)0, (int)2, null);
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            i = (MatchResult)element$iv;
            boolean bl = false;
            result.add(new UploadImageNode((String)i.getGroupValues().get(1), i.getRange()));
        }
        $this$forEach$iv = Regex.findAll$default((Regex)PIXIV_IMAGE_REGEX, (CharSequence)str, (int)0, (int)2, null);
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            Collection collection;
            void $this$mapTo$iv$iv2;
            i = (MatchResult)element$iv;
            boolean bl = false;
            Object object2 = new String[]{"-"};
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)((CharSequence)i.getGroupValues().get(1)), (String[])object2, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                String string = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(Integer.parseInt((String)it));
            }
            List arr = (List)destination$iv$iv;
            Collection<PixivImageNode> collection2 = result;
            int n = ((Number)arr.get(0)).intValue();
            int n2 = 1;
            object2 = arr;
            if (n2 < object2.size()) {
                object = object2.get(n2);
            } else {
                int $this$mapTo$iv$iv2 = n2;
                int n3 = n;
                collection = collection2;
                boolean bl3 = false;
                Integer n4 = 1;
                collection2 = collection;
                n = n3;
                object = n4;
            }
            IntRange intRange = i.getRange();
            int n5 = ((Number)object).intValue() - 1;
            int n6 = n;
            collection2.add(new PixivImageNode(n6, n5, intRange));
        }
        $this$forEach$iv = Regex.findAll$default((Regex)NEW_PAGE_REGEX, (CharSequence)str, (int)0, (int)2, null);
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            i = (MatchResult)element$iv;
            boolean bl = false;
            result.add(new NewPageNode(i.getRange()));
        }
        $this$forEach$iv = Regex.findAll$default((Regex)CHAPTER_REGEX, (CharSequence)str, (int)0, (int)2, null);
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            i = (MatchResult)element$iv;
            boolean bl = false;
            result.add(new TitleNode((String)i.getGroupValues().get(1), i.getRange()));
        }
        $this$forEach$iv = Regex.findAll$default((Regex)JUMP_PAGE_REGEX, (CharSequence)str, (int)0, (int)2, null);
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            i = (MatchResult)element$iv;
            boolean bl = false;
            result.add(new JumpPageNode(Integer.parseInt((String)i.getGroupValues().get(1)), i.getRange()));
        }
        List $this$sortBy$iv = result;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    NovelNode it = (NovelNode)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getPosition().getFirst());
                    it = (NovelNode)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getPosition().getFirst()));
                }
            });
        }
        if (result.isEmpty()) {
            return CollectionsKt.listOf((Object)new PlainTextNode(str, new IntRange(0, str.length())));
        }
        int index = -1;
        int n = ((Collection)result).size();
        for (int i2 = 0; i2 < n; ++i2) {
            NovelNode ele = (NovelNode)result.get(i2);
            String string = str.substring(index + 1, ele.getPosition().getFirst());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            result.add(new PlainTextNode(string, new IntRange(index, ele.getPosition().getFirst())));
            index = ele.getPosition().getLast();
        }
        if (index < str.length()) {
            String string = str.substring(index + 1, str.length());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            result.add(new PlainTextNode(string, new IntRange(index, str.length())));
        }
        List $this$sortBy$iv2 = result;
        boolean $i$f$sortBy2 = false;
        if ($this$sortBy$iv2.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv2, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    NovelNode it = (NovelNode)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getPosition().getFirst());
                    it = (NovelNode)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getPosition().getFirst()));
                }
            });
        }
        return result;
    }

    @NotNull
    public static final String toOriginalString(@NotNull List<? extends NovelNode> $this$toOriginalString) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter($this$toOriginalString, (String)"<this>");
        StringBuilder $this$toOriginalString_u24lambda_u2412 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Iterable $this$forEach$iv = $this$toOriginalString;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            NovelNode v = (NovelNode)element$iv;
            boolean bl2 = false;
            NovelNode novelNode = v;
            if (novelNode instanceof PlainTextNode) {
                object = ((PlainTextNode)v).getText();
            } else if (novelNode instanceof JumpUriNode) {
                object = "[[jumpuri:" + ((JumpUriNode)v).getText() + ">" + ((JumpUriNode)v).getUri() + "]]";
            } else if (novelNode instanceof NotationNode) {
                object = "[[rb:" + ((NotationNode)v).getText() + ">" + ((NotationNode)v).getNotation() + "]]";
            } else if (novelNode instanceof UploadImageNode) {
                object = "[uploadedimage:" + ((UploadImageNode)v).getUrl() + "]";
            } else if (novelNode instanceof PixivImageNode) {
                object = "[pixivimage:" + ((PixivImageNode)v).getId() + "]";
            } else if (novelNode instanceof NewPageNode) {
                object = "[newpage]";
            } else if (novelNode instanceof TitleNode) {
                object = "[chapter:" + ((TitleNode)v).getText() + "]";
            } else if (novelNode instanceof JumpPageNode) {
                object = "[jump:" + ((JumpPageNode)v).getPage() + "]";
            } else {
                throw new NoWhenBranchMatchedException();
            }
            $this$toOriginalString_u24lambda_u2412.append((String)object);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

