/*
 * Decompiled with CFR 0.152.
 */
package top.kmar.game.map;

import it.unimi.dsi.fastutil.ints.Int2ObjectRBTreeMap;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.Closeable;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.kmar.game.ConsolePrinter;
import top.kmar.game.EventListener;
import top.kmar.game.map.GEntity;
import top.kmar.game.map.Point2D;
import top.kmar.game.map.Rect2D;
import top.kmar.game.map.SafeGraphics;
import top.kmar.game.map.SafeGraphicsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\n\u0018\u0000 32\u00020\u0001:\u0003123B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u001e\u001a\u00020\bH\u0002J\b\u0010\u001f\u001a\u00020 H\u0016J\u0006\u0010!\u001a\u00020 J\u0016\u0010\"\u001a\u00020 2\u0006\u0010#\u001a\u00020\b2\u0006\u0010$\u001a\u00020\u0003J\u0006\u0010%\u001a\u00020 J\u000e\u0010&\u001a\u00020 2\u0006\u0010'\u001a\u00020\u0019J\u0016\u0010(\u001a\u00020 2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u0019J\u001e\u0010(\u001a\u00020 2\u0006\u0010)\u001a\u00020*2\u0006\u0010,\u001a\u00020*2\u0006\u0010+\u001a\u00020\u0019J\u0010\u0010-\u001a\u00020 2\u0006\u0010)\u001a\u00020*H\u0002J\u0006\u0010.\u001a\u00020 J\u000e\u0010/\u001a\u00020 2\u0006\u00100\u001a\u00020*R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\nR\u001a\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\b0\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0013\u00a8\u00064"}, d2={"Ltop/kmar/game/map/GMap;", "Ljava/io/Closeable;", "width", "", "height", "(II)V", "allEntity", "Ljava/util/stream/Stream;", "Ltop/kmar/game/map/GEntity;", "getAllEntity", "()Ljava/util/stream/Stream;", "closed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "collisibleEntity", "getCollisibleEntity", "entities", "Lit/unimi/dsi/fastutil/ints/Int2ObjectRBTreeMap;", "", "getHeight", "()I", "prev", "Ljava/util/concurrent/atomic/AtomicLong;", "stopped", "taskList", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Ljava/util/function/BooleanSupplier;", "visibleEntity", "getVisibleEntity", "getWidth", "checkCollision", "from", "close", "", "invokeThreadTask", "putEntity", "entity", "layout", "render", "runTaskOnLogicThread", "task", "start", "eventInterval", "", "logicCondition", "logicInterval", "startEventThread", "stop", "update", "time", "Builder", "BuilderJava", "Companion", "cg-engine"})
@SourceDebugExtension(value={"SMAP\nGMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GMap.kt\ntop/kmar/game/map/GMap\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,396:1\n1#2:397\n361#3,7:398\n1855#4,2:405\n*S KotlinDebug\n*F\n+ 1 GMap.kt\ntop/kmar/game/map/GMap\n*L\n66#1:398,7\n220#1:405,2\n*E\n"})
public final class GMap
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int width;
    private final int height;
    @NotNull
    private final Int2ObjectRBTreeMap<Set<GEntity>> entities;
    @NotNull
    private final AtomicBoolean closed;
    @NotNull
    private final AtomicBoolean stopped;
    @NotNull
    private final ConcurrentLinkedQueue<BooleanSupplier> taskList;
    @NotNull
    private AtomicLong prev;
    @NotNull
    private static final AtomicReference<Timer> timer = new AtomicReference();

    private GMap(int width, int height) {
        this.width = width;
        this.height = height;
        this.entities = new Int2ObjectRBTreeMap();
        this.closed = new AtomicBoolean(false);
        this.stopped = new AtomicBoolean(false);
        this.taskList = new ConcurrentLinkedQueue();
        this.prev = new AtomicLong(0L);
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    @NotNull
    public final Stream<GEntity> getAllEntity() {
        Stream<Object> stream = ((ObjectCollection)this.entities.values()).stream().flatMap(arg_0 -> GMap._get_allEntity_$lambda$1(GMap::_get_allEntity_$lambda$0, arg_0)).filter(arg_0 -> GMap._get_allEntity_$lambda$3(GMap::_get_allEntity_$lambda$2, arg_0));
        Intrinsics.checkNotNullExpressionValue(stream, (String)"entities.values.stream()\u2026m() }.filter { !it.died }");
        return stream;
    }

    @NotNull
    public final Stream<GEntity> getVisibleEntity() {
        Stream<Object> stream = this.getAllEntity().filter(arg_0 -> GMap._get_visibleEntity_$lambda$5(GMap::_get_visibleEntity_$lambda$4, arg_0));
        Intrinsics.checkNotNullExpressionValue(stream, (String)"allEntity.filter { it.visible }");
        return stream;
    }

    @NotNull
    public final Stream<GEntity> getCollisibleEntity() {
        Stream<Object> stream = this.getAllEntity().filter(arg_0 -> GMap._get_collisibleEntity_$lambda$7(GMap::_get_collisibleEntity_$lambda$6, arg_0));
        Intrinsics.checkNotNullExpressionValue(stream, (String)"allEntity.filter { it.collisible }");
        return stream;
    }

    private final Stream<GEntity> checkCollision(GEntity from) {
        if (!from.getCollisible()) {
            Stream<GEntity> stream = Stream.empty();
            Intrinsics.checkNotNullExpressionValue(stream, (String)"empty()");
            return stream;
        }
        Rect2D bound = from.getBound();
        Set collision = from.getCollision(0, 0, from.getWidth(), from.getHeight()).collect(Collectors.toSet());
        Stream<Object> stream = this.getCollisibleEntity().filter(arg_0 -> GMap.checkCollision$lambda$9(arg_0 -> GMap.checkCollision$lambda$8(from, arg_0), arg_0)).filter(arg_0 -> GMap.checkCollision$lambda$13(arg_0 -> GMap.checkCollision$lambda$12(bound, collision, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue(stream, (String)"collisibleEntity\n       \u2026collision }\n            }");
        return stream;
    }

    /*
     * WARNING - void declaration
     */
    public final void putEntity(@NotNull GEntity entity, int layout) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (!(!this.closed.get())) {
            boolean $i$a$-require-GMap$putEntity$22 = false;
            String $i$a$-require-GMap$putEntity$22 = "\u5f53\u524d GMap \u5df2\u7ecf\u88ab\u5173\u95ed\uff0c\u65e0\u6cd5\u6267\u884c\u52a8\u4f5c";
            throw new IllegalArgumentException($i$a$-require-GMap$putEntity$22.toString());
        }
        Map $i$a$-require-GMap$putEntity$22 = (Map)this.entities;
        Integer key$iv = layout;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            Set answer$iv = (Set)new ObjectOpenHashSet(this.width * this.height);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        Set list = (Set)object;
        list.add(entity);
        entity.onGenerate(this);
        this.checkCollision(entity).forEach(arg_0 -> GMap.putEntity$lambda$17(arg_0 -> GMap.putEntity$lambda$16(this, entity, arg_0), arg_0));
    }

    public final void render() {
        if (!(!this.closed.get())) {
            boolean bl = false;
            String string = "\u5f53\u524d GMap \u5df2\u7ecf\u88ab\u5173\u95ed\uff0c\u65e0\u6cd5\u6267\u884c\u52a8\u4f5c";
            throw new IllegalArgumentException(string.toString());
        }
        this.getVisibleEntity().forEach(arg_0 -> GMap.render$lambda$20(arg_0 -> GMap.render$lambda$19(this, arg_0), arg_0));
        ConsolePrinter.flush$default(0, 1, null);
    }

    public final void runTaskOnLogicThread(@NotNull BooleanSupplier task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        if (!(!this.closed.get())) {
            boolean bl = false;
            String string = "\u5f53\u524d GMap \u5df2\u7ecf\u88ab\u5173\u95ed\uff0c\u65e0\u6cd5\u6267\u884c\u52a8\u4f5c";
            throw new IllegalArgumentException(string.toString());
        }
        this.taskList.add(task);
    }

    public final void invokeThreadTask() {
        if (!(!this.closed.get())) {
            boolean $i$a$-require-GMap$invokeThreadTask$22 = false;
            String $i$a$-require-GMap$invokeThreadTask$22 = "\u5f53\u524d GMap \u5df2\u7ecf\u88ab\u5173\u95ed\uff0c\u65e0\u6cd5\u6267\u884c\u52a8\u4f5c";
            throw new IllegalArgumentException($i$a$-require-GMap$invokeThreadTask$22.toString());
        }
        Iterator<BooleanSupplier> iterator = this.taskList.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"taskList.iterator()");
        Iterator<BooleanSupplier> itor = iterator;
        while (itor.hasNext()) {
            BooleanSupplier item = itor.next();
            if (!item.getAsBoolean()) continue;
            itor.remove();
        }
    }

    public final void start(long eventInterval, long logicInterval, @NotNull BooleanSupplier logicCondition) {
        Intrinsics.checkNotNullParameter((Object)logicCondition, (String)"logicCondition");
        this.startEventThread(eventInterval);
        Thread.currentThread().setName("Logic Thread");
        this.prev.set(System.currentTimeMillis());
        long offset = 0L;
        long sleepBound = logicInterval - (long)2;
        do {
            long prev = this.prev.get();
            long now = System.currentTimeMillis();
            long time = now - prev + offset;
            while (time < sleepBound) {
                Thread.sleep(sleepBound - time);
                now = System.currentTimeMillis();
                time = now - prev + offset;
            }
            while (time < logicInterval) {
                now = System.currentTimeMillis();
                time = now - prev + offset;
            }
            time = now - prev;
            offset += time - logicInterval;
            this.prev.set(now);
            this.invokeThreadTask();
            this.update(time);
            this.render();
        } while (!this.stopped.get() && logicCondition.getAsBoolean());
        timer.get().cancel();
    }

    public final void start(long eventInterval, @NotNull BooleanSupplier logicCondition) {
        Intrinsics.checkNotNullParameter((Object)logicCondition, (String)"logicCondition");
        this.startEventThread(eventInterval);
        Thread.currentThread().setName("Logic Thread");
        this.prev.set(System.currentTimeMillis());
        do {
            long now = System.currentTimeMillis();
            long time = now - this.prev.get();
            this.prev.set(now);
            this.invokeThreadTask();
            this.update(time);
            this.render();
        } while (!this.stopped.get() && logicCondition.getAsBoolean());
        timer.get().cancel();
    }

    private final void startEventThread(long eventInterval) {
        if (!(!this.closed.get())) {
            boolean bl = false;
            String string = "\u5f53\u524d GMap \u5df2\u7ecf\u88ab\u5173\u95ed\uff0c\u65e0\u6cd5\u6267\u884c\u52a8\u4f5c";
            throw new IllegalArgumentException(string.toString());
        }
        if (timer.get() != null) {
            throw new AssertionError((Object)"\u4e0d\u5e94\u8be5\u91cd\u590d\u542f\u52a8\u65f6\u5e8f\u63a7\u5236");
        }
        Timer value = new Timer("Event Listener Thread", true);
        value.scheduleAtFixedRate(new TimerTask(){

            public void run() {
                EventListener.pushButtonEvent();
                EventListener.pushMouseLocationEvent();
            }
        }, eventInterval, eventInterval);
        timer.set(value);
    }

    public final void stop() {
        if (!(this.prev.get() != 0L)) {
            boolean bl = false;
            String string = "\u4efb\u52a1\u672a\u542f\u52a8";
            throw new IllegalArgumentException(string.toString());
        }
        this.stopped.set(true);
    }

    public final void update(long time) {
        if (!(!this.closed.get())) {
            boolean $i$a$-require-GMap$update$22 = false;
            String $i$a$-require-GMap$update$22 = "\u5f53\u524d GMap \u5df2\u7ecf\u88ab\u5173\u95ed\uff0c\u65e0\u6cd5\u6267\u884c\u52a8\u4f5c";
            throw new IllegalArgumentException($i$a$-require-GMap$update$22.toString());
        }
        this.getAllEntity().forEach(arg_0 -> GMap.update$lambda$27(arg_0 -> GMap.update$lambda$26(this, time, arg_0), arg_0));
        Collection collection = this.entities.values();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"entities.values");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Set list = (Set)element$iv;
            boolean bl = false;
            Iterator itor = list.iterator();
            while (itor.hasNext()) {
                GEntity item = (GEntity)itor.next();
                if (!item.getDied()) continue;
                itor.remove();
                item.onRemove(this);
            }
        }
    }

    @Override
    public void close() {
        if (!(this.prev.get() == 0L)) {
            boolean $i$a$-require-GMap$close$22 = false;
            String $i$a$-require-GMap$close$22 = "GMap \u7684\u903b\u8f91\u6b63\u5728\u8fdb\u884c\uff0c\u65e0\u6cd5\u5173\u95ed";
            throw new IllegalArgumentException($i$a$-require-GMap$close$22.toString());
        }
        this.closed.set(true);
        Iterator iterator = Builder.getList$cg_engine().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"list.iterator()");
        Iterator itor = iterator;
        while (itor.hasNext()) {
            GMap item = (GMap)((WeakReference)itor.next()).get();
            if (item == null) {
                itor.remove();
                continue;
            }
            if (!Intrinsics.areEqual((Object)item, (Object)this)) continue;
            itor.remove();
            break;
        }
    }

    private static final Stream _get_allEntity_$lambda$0(Set it) {
        return it.stream();
    }

    private static final Stream _get_allEntity_$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Stream)$tmp0.invoke(p0);
    }

    private static final boolean _get_allEntity_$lambda$2(GEntity it) {
        return !it.getDied();
    }

    private static final boolean _get_allEntity_$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean _get_visibleEntity_$lambda$4(GEntity it) {
        return it.getVisible();
    }

    private static final boolean _get_visibleEntity_$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean _get_collisibleEntity_$lambda$6(GEntity it) {
        return it.getCollisible();
    }

    private static final boolean _get_collisibleEntity_$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean checkCollision$lambda$8(GEntity $from, GEntity it) {
        Intrinsics.checkNotNullParameter((Object)$from, (String)"$from");
        return !Intrinsics.areEqual((Object)it, (Object)$from);
    }

    private static final boolean checkCollision$lambda$9(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean checkCollision$lambda$12$lambda$10(Set $collision, Point2D it) {
        return $collision.contains(it);
    }

    private static final boolean checkCollision$lambda$12$lambda$11(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean checkCollision$lambda$12(Rect2D $bound, Set $collision, GEntity entity) {
        Intrinsics.checkNotNullParameter((Object)$bound, (String)"$bound");
        Rect2D itBound = entity.getBound();
        if (!$bound.hasIntersection(itBound)) {
            return false;
        }
        Rect2D rect2D = $bound.intersect(entity.getBound());
        Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"entity");
        Rect2D rect = rect2D.mapToEntity(entity);
        return entity.getCollision(rect).anyMatch(arg_0 -> GMap.checkCollision$lambda$12$lambda$11(arg_0 -> GMap.checkCollision$lambda$12$lambda$10($collision, arg_0), arg_0));
    }

    private static final boolean checkCollision$lambda$13(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit putEntity$lambda$16(GMap this$0, GEntity $entity, GEntity it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$entity, (String)"$entity");
        it.onCollision(this$0, $entity);
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        $entity.onCollision(this$0, it);
        return Unit.INSTANCE;
    }

    private static final void putEntity$lambda$17(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final Unit render$lambda$19(GMap this$0, GEntity it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        SafeGraphics graphics = SafeGraphicsKt._ do not use(this$0, it.getX(), it.getY(), it.getWidth(), it.getHeight(), ConsolePrinter.getIndex());
        it.render(graphics);
        return Unit.INSTANCE;
    }

    private static final void render$lambda$20(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final Unit update$lambda$26(GMap this$0, long $time, GEntity it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        it.update(this$0, $time);
        return Unit.INSTANCE;
    }

    private static final void update$lambda$27(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public /* synthetic */ GMap(int width, int height, DefaultConstructorMarker $constructor_marker) {
        this(width, height);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010/\u001a\u00020'H\u0007J\b\u00100\u001a\u00020\u0013H\u0007R,\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048\u0006@FX\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR0\u0010\f\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0003\u001a\u0004\u0018\u00010\u000b8\u0006@FX\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\r\u0010\u0002\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0018\u0010\u0012\u001a\u00020\u00138\u0002@\u0002X\u0083\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0014\u0010\u0002R,\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048\u0006@FX\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0016\u0010\u0002\u001a\u0004\b\u0017\u0010\b\"\u0004\b\u0018\u0010\nR,\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048\u0006@FX\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u001a\u0010\u0002\u001a\u0004\b\u001b\u0010\b\"\u0004\b\u001c\u0010\nR2\u0010\u001d\u001a\u0004\u0018\u00010\u00132\b\u0010\u0003\u001a\u0004\u0018\u00010\u00138\u0006@FX\u0087\u000e\u00a2\u0006\u0016\n\u0002\u0010#\u0012\u0004\b\u001e\u0010\u0002\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R(\u0010$\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020'0&0%8\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b(\u0010\u0002\u001a\u0004\b)\u0010*R,\u0010+\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048\u0006@FX\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b,\u0010\u0002\u001a\u0004\b-\u0010\b\"\u0004\b.\u0010\n\u00a8\u00061"}, d2={"Ltop/kmar/game/map/GMap$Builder;", "", "()V", "value", "", "cache", "getCache$annotations", "getCache", "()I", "setCache", "(I)V", "Ljava/io/File;", "file", "getFile$annotations", "getFile", "()Ljava/io/File;", "setFile", "(Ljava/io/File;)V", "flag", "", "getFlag$annotations", "fontWidth", "getFontWidth$annotations", "getFontWidth", "setFontWidth", "height", "getHeight$annotations", "getHeight", "setHeight", "ignoreClose", "getIgnoreClose$annotations", "getIgnoreClose", "()Ljava/lang/Boolean;", "setIgnoreClose", "(Ljava/lang/Boolean;)V", "Ljava/lang/Boolean;", "list", "Ljava/util/LinkedList;", "Ljava/lang/ref/WeakReference;", "Ltop/kmar/game/map/GMap;", "getList$cg_engine$annotations", "getList$cg_engine", "()Ljava/util/LinkedList;", "width", "getWidth$annotations", "getWidth", "setWidth", "build", "dispose", "cg-engine"})
    @SourceDebugExtension(value={"SMAP\nGMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GMap.kt\ntop/kmar/game/map/GMap$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,396:1\n1#2:397\n*E\n"})
    public static final class Builder {
        @NotNull
        public static final Builder INSTANCE = new Builder();
        private static int width = -1;
        private static int height = -1;
        private static int fontWidth = -1;
        private static int cache = -1;
        @Nullable
        private static Boolean ignoreClose;
        @Nullable
        private static File file;
        private static boolean flag;
        @NotNull
        private static final LinkedList<WeakReference<GMap>> list;

        private Builder() {
        }

        public static final int getWidth() {
            return width;
        }

        public static final void setWidth(int value) {
            if (!(width == -1)) {
                boolean $i$a$-require-GMap$Builder$width$32 = false;
                String $i$a$-require-GMap$Builder$width$32 = "\u4e0d\u80fd\u91cd\u590d\u521d\u59cb\u5316\u5c5e\u6027";
                throw new IllegalArgumentException($i$a$-require-GMap$Builder$width$32.toString());
            }
            if (!(value > 0)) {
                boolean bl = false;
                String string = "\u5bbd\u5ea6\u5e94\u8be5\u5927\u4e8e 0";
                throw new IllegalArgumentException(string.toString());
            }
            width = value;
        }

        @JvmStatic
        public static /* synthetic */ void getWidth$annotations() {
        }

        public static final int getHeight() {
            return height;
        }

        public static final void setHeight(int value) {
            if (!(height == -1)) {
                boolean $i$a$-require-GMap$Builder$height$32 = false;
                String $i$a$-require-GMap$Builder$height$32 = "\u4e0d\u80fd\u91cd\u590d\u521d\u59cb\u5316\u5c5e\u6027";
                throw new IllegalArgumentException($i$a$-require-GMap$Builder$height$32.toString());
            }
            if (!(value > 0)) {
                boolean bl = false;
                String string = "\u9ad8\u5ea6\u5e94\u8be5\u5927\u4e8e 0";
                throw new IllegalArgumentException(string.toString());
            }
            height = value;
        }

        @JvmStatic
        public static /* synthetic */ void getHeight$annotations() {
        }

        public static final int getFontWidth() {
            return fontWidth;
        }

        public static final void setFontWidth(int value) {
            if (!(fontWidth == -1)) {
                boolean $i$a$-require-GMap$Builder$fontWidth$32 = false;
                String $i$a$-require-GMap$Builder$fontWidth$32 = "\u4e0d\u80fd\u91cd\u590d\u521d\u59cb\u5316\u5c5e\u6027";
                throw new IllegalArgumentException($i$a$-require-GMap$Builder$fontWidth$32.toString());
            }
            if (!(value > 0)) {
                boolean bl = false;
                String string = "\u5bbd\u5ea6\u5e94\u8be5\u5927\u4e8e 0";
                throw new IllegalArgumentException(string.toString());
            }
            fontWidth = value;
        }

        @JvmStatic
        public static /* synthetic */ void getFontWidth$annotations() {
        }

        public static final int getCache() {
            return cache;
        }

        public static final void setCache(int value) {
            if (!(cache == -1)) {
                boolean $i$a$-require-GMap$Builder$cache$32 = false;
                String $i$a$-require-GMap$Builder$cache$32 = "\u4e0d\u80fd\u91cd\u590d\u521d\u59cb\u5316\u5c5e\u6027";
                throw new IllegalArgumentException($i$a$-require-GMap$Builder$cache$32.toString());
            }
            if (!(value > 0)) {
                boolean bl = false;
                String string = "\u7f13\u5b58\u6570\u91cf\u5e94\u8be5\u5927\u4e8e 0";
                throw new IllegalArgumentException(string.toString());
            }
            cache = value;
        }

        @JvmStatic
        public static /* synthetic */ void getCache$annotations() {
        }

        @Nullable
        public static final Boolean getIgnoreClose() {
            return ignoreClose;
        }

        public static final void setIgnoreClose(@Nullable Boolean value) {
            if (!(ignoreClose == null)) {
                boolean $i$a$-require-GMap$Builder$ignoreClose$32 = false;
                String $i$a$-require-GMap$Builder$ignoreClose$32 = "\u4e0d\u80fd\u91cd\u590d\u521d\u59cb\u5316\u5c5e\u6027";
                throw new IllegalArgumentException($i$a$-require-GMap$Builder$ignoreClose$32.toString());
            }
            if (!(value != null)) {
                boolean bl = false;
                String string = "\u503c\u4e0d\u5e94\u5f53\u4e3a NULL";
                throw new IllegalArgumentException(string.toString());
            }
            ignoreClose = value;
        }

        @JvmStatic
        public static /* synthetic */ void getIgnoreClose$annotations() {
        }

        @Nullable
        public static final File getFile() {
            return file;
        }

        public static final void setFile(@Nullable File value) {
            if (!(file == null)) {
                boolean $i$a$-require-GMap$Builder$file$32 = false;
                String $i$a$-require-GMap$Builder$file$32 = "\u4e0d\u80fd\u91cd\u590d\u521d\u59cb\u5316\u5c5e\u6027";
                throw new IllegalArgumentException($i$a$-require-GMap$Builder$file$32.toString());
            }
            if (!(value != null)) {
                boolean bl = false;
                String string = "\u503c\u4e0d\u5e94\u5f53\u4e3a NULL";
                throw new IllegalArgumentException(string.toString());
            }
            file = value;
        }

        @JvmStatic
        public static /* synthetic */ void getFile$annotations() {
        }

        @JvmStatic
        private static /* synthetic */ void getFlag$annotations() {
        }

        @NotNull
        public static final LinkedList<WeakReference<GMap>> getList$cg_engine() {
            return list;
        }

        @JvmStatic
        public static /* synthetic */ void getList$cg_engine$annotations() {
        }

        @JvmStatic
        @NotNull
        public static final GMap build() {
            if (!(width != -1)) {
                boolean $i$a$-require-GMap$Builder$build$32 = false;
                String $i$a$-require-GMap$Builder$build$32 = "\u5bbd\u5ea6\u5c5e\u6027\u672a\u521d\u59cb\u5316";
                throw new IllegalArgumentException($i$a$-require-GMap$Builder$build$32.toString());
            }
            if (!(height != -1)) {
                boolean bl = false;
                String string = "\u9ad8\u5ea6\u5c5e\u6027\u672a\u521d\u59cb\u5316";
                throw new IllegalArgumentException(string.toString());
            }
            if (fontWidth == -1) {
                Builder.setFontWidth(10);
            }
            if (cache == -10) {
                Builder.setCache(2);
            }
            if (ignoreClose == null) {
                Builder.setIgnoreClose(false);
            }
            if (file == null) {
                Builder.setFile(new File("utils.dll"));
            }
            if (flag) {
                flag = false;
                Boolean bl = ignoreClose;
                Intrinsics.checkNotNull((Object)bl);
                boolean bl2 = bl;
                File file = Builder.file;
                Intrinsics.checkNotNull((Object)file);
                ConsolePrinter.init(width, height, fontWidth, cache, bl2, file);
            }
            list.removeIf(arg_0 -> Builder.build$lambda$15(Builder::build$lambda$14, arg_0));
            GMap map = new GMap(width, height, null);
            list.add(new WeakReference<GMap>(map));
            return map;
        }

        @JvmStatic
        public static final boolean dispose() {
            boolean bl;
            list.removeIf(arg_0 -> Builder.dispose$lambda$17(Builder::dispose$lambda$16, arg_0));
            if (list.isEmpty()) {
                ConsolePrinter.dispose();
                flag = true;
                bl = true;
            } else {
                System.gc();
                list.removeIf(arg_0 -> Builder.dispose$lambda$19(Builder::dispose$lambda$18, arg_0));
                if (list.isEmpty()) {
                    ConsolePrinter.dispose();
                    flag = true;
                    bl = true;
                } else {
                    bl = false;
                }
            }
            return bl;
        }

        private static final boolean build$lambda$14(WeakReference it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.get() == null;
        }

        private static final boolean build$lambda$15(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final boolean dispose$lambda$16(WeakReference it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.get() == null;
        }

        private static final boolean dispose$lambda$17(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final boolean dispose$lambda$18(WeakReference it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.get() == null;
        }

        private static final boolean dispose$lambda$19(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Boolean)$tmp0.invoke(p0);
        }

        static {
            flag = true;
            list = new LinkedList();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0007J\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0006J\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\u0011"}, d2={"Ltop/kmar/game/map/GMap$BuilderJava;", "", "()V", "build", "Ltop/kmar/game/map/GMap;", "dispose", "", "setCache", "value", "", "setFile", "file", "Ljava/io/File;", "setFontWidth", "setHeight", "setIgnoreClose", "setWidth", "cg-engine"})
    public static final class BuilderJava {
        @NotNull
        public static final BuilderJava INSTANCE = new BuilderJava();

        private BuilderJava() {
        }

        @NotNull
        public final BuilderJava setWidth(int value) {
            Builder.setWidth(value);
            return this;
        }

        @NotNull
        public final BuilderJava setHeight(int value) {
            Builder.setHeight(value);
            return this;
        }

        @NotNull
        public final BuilderJava setCache(int value) {
            Builder.setCache(value);
            return this;
        }

        @NotNull
        public final BuilderJava setFontWidth(int value) {
            Builder.setFontWidth(value);
            return this;
        }

        @NotNull
        public final BuilderJava setIgnoreClose(boolean value) {
            Builder.setIgnoreClose(value);
            return this;
        }

        @NotNull
        public final BuilderJava setFile(@NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Builder.setFile(file);
            return this;
        }

        @NotNull
        public final GMap build() {
            return Builder.build();
        }

        @JvmStatic
        public static final boolean dispose() {
            return Builder.dispose();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Ltop/kmar/game/map/GMap$Companion;", "", "()V", "timer", "Ljava/util/concurrent/atomic/AtomicReference;", "Ljava/util/Timer;", "getTimer", "()Ljava/util/concurrent/atomic/AtomicReference;", "cg-engine"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AtomicReference<Timer> getTimer() {
            return timer;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

